@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCatalogTable.
 * @property arn The ARN of the Glue Table.
 * @property catalogId ID of the Data Catalog in which the table resides.
 * @property databaseName Name of the catalog database that contains the target table.
 * @property description Description of the table.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the target table.
 * @property owner Owner of the table.
 * @property parameters Map of initialization parameters for the SerDe, in key-value form.
 * @property partitionIndices Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
 * @property partitionKeys Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
 * @property queryAsOfTime
 * @property retention Retention time for this table.
 * @property storageDescriptors Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
 * @property tableType Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
 * @property targetTables Configuration block of a target table for resource linking. See `target_table` below.
 * @property transactionId
 * @property viewExpandedText If the table is a view, the expanded text of the view; otherwise null.
 * @property viewOriginalText If the table is a view, the original text of the view; otherwise null.
 */
public data class GetCatalogTableResult(
    public val arn: String,
    public val catalogId: String,
    public val databaseName: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val owner: String,
    public val parameters: Map<String, String>,
    public val partitionIndices: List<GetCatalogTablePartitionIndex>,
    public val partitionKeys: List<GetCatalogTablePartitionKey>,
    public val queryAsOfTime: String? = null,
    public val retention: Int,
    public val storageDescriptors: List<GetCatalogTableStorageDescriptor>,
    public val tableType: String,
    public val targetTables: List<GetCatalogTableTargetTable>,
    public val transactionId: Int? = null,
    public val viewExpandedText: String,
    public val viewOriginalText: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTableResult):
            GetCatalogTableResult = GetCatalogTableResult(
            arn = javaType.arn(),
            catalogId = javaType.catalogId(),
            databaseName = javaType.databaseName(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            owner = javaType.owner(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            partitionIndices = javaType.partitionIndices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTablePartitionIndex.Companion.toKotlin(args0)
                })
            }),
            partitionKeys = javaType.partitionKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTablePartitionKey.Companion.toKotlin(args0)
                })
            }),
            queryAsOfTime = javaType.queryAsOfTime().map({ args0 -> args0 }).orElse(null),
            retention = javaType.retention(),
            storageDescriptors = javaType.storageDescriptors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableStorageDescriptor.Companion.toKotlin(args0)
                })
            }),
            tableType = javaType.tableType(),
            targetTables = javaType.targetTables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableTargetTable.Companion.toKotlin(args0)
                })
            }),
            transactionId = javaType.transactionId().map({ args0 -> args0 }).orElse(null),
            viewExpandedText = javaType.viewExpandedText(),
            viewOriginalText = javaType.viewOriginalText(),
        )
    }
}
