@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property bucketColumns List of reducer grouping columns, clustering columns, and bucketing columns in the table.
 * @property columns Configuration block for columns in the table. See `columns` below.
 * @property compressed Whether the data in the table is compressed.
 * @property inputFormat Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
 * @property location Physical location of the table. By default, this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
 * @property numberOfBuckets Is if the table contains any dimension columns.
 * @property outputFormat Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
 * @property parameters Map of initialization parameters for the SerDe, in key-value form.
 * @property schemaReferences Object that references a schema stored in the AWS Glue Schema Registry. See `schema_reference` below.
 * @property serDeInfos Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
 * @property skewedInfos Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
 * @property sortColumns Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
 * @property storedAsSubDirectories Whether the table data is stored in subdirectories.
 */
public data class GetCatalogTableStorageDescriptor(
    public val bucketColumns: List<String>,
    public val columns: List<GetCatalogTableStorageDescriptorColumn>,
    public val compressed: Boolean,
    public val inputFormat: String,
    public val location: String,
    public val numberOfBuckets: Int,
    public val outputFormat: String,
    public val parameters: Map<String, String>,
    public val schemaReferences: List<GetCatalogTableStorageDescriptorSchemaReference>,
    public val serDeInfos: List<GetCatalogTableStorageDescriptorSerDeInfo>,
    public val skewedInfos: List<GetCatalogTableStorageDescriptorSkewedInfo>,
    public val sortColumns: List<GetCatalogTableStorageDescriptorSortColumn>,
    public val storedAsSubDirectories: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTableStorageDescriptor):
            GetCatalogTableStorageDescriptor = GetCatalogTableStorageDescriptor(
            bucketColumns = javaType.bucketColumns().map({ args0 -> args0 }),
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableStorageDescriptorColumn.Companion.toKotlin(args0)
                })
            }),
            compressed = javaType.compressed(),
            inputFormat = javaType.inputFormat(),
            location = javaType.location(),
            numberOfBuckets = javaType.numberOfBuckets(),
            outputFormat = javaType.outputFormat(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            schemaReferences = javaType.schemaReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableStorageDescriptorSchemaReference.Companion.toKotlin(args0)
                })
            }),
            serDeInfos = javaType.serDeInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableStorageDescriptorSerDeInfo.Companion.toKotlin(args0)
                })
            }),
            skewedInfos = javaType.skewedInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableStorageDescriptorSkewedInfo.Companion.toKotlin(args0)
                })
            }),
            sortColumns = javaType.sortColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableStorageDescriptorSortColumn.Companion.toKotlin(args0)
                })
            }),
            storedAsSubDirectories = javaType.storedAsSubDirectories(),
        )
    }
}
