@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property schemaIds Configuration block that contains schema identity fields. See `schema_id` below.
 * @property schemaVersionId Unique ID assigned to a version of the schema.
 * @property schemaVersionNumber Version number of the schema.
 */
public data class GetCatalogTableStorageDescriptorSchemaReference(
    public val schemaIds: List<GetCatalogTableStorageDescriptorSchemaReferenceSchemaId>,
    public val schemaVersionId: String,
    public val schemaVersionNumber: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTableStorageDescriptorSchemaReference):
            GetCatalogTableStorageDescriptorSchemaReference =
            GetCatalogTableStorageDescriptorSchemaReference(
                schemaIds = javaType.schemaIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableStorageDescriptorSchemaReferenceSchemaId.Companion.toKotlin(args0)
                    })
                }),
                schemaVersionId = javaType.schemaVersionId(),
                schemaVersionNumber = javaType.schemaVersionNumber(),
            )
    }
}
