@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property skewedColumnNames List of names of columns that contain skewed values.
 * @property skewedColumnValueLocationMaps List of values that appear so frequently as to be considered skewed.
 * @property skewedColumnValues Map of skewed values to the columns that contain them.
 */
public data class GetCatalogTableStorageDescriptorSkewedInfo(
    public val skewedColumnNames: List<String>,
    public val skewedColumnValueLocationMaps: Map<String, String>,
    public val skewedColumnValues: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTableStorageDescriptorSkewedInfo):
            GetCatalogTableStorageDescriptorSkewedInfo = GetCatalogTableStorageDescriptorSkewedInfo(
            skewedColumnNames = javaType.skewedColumnNames().map({ args0 -> args0 }),
            skewedColumnValueLocationMaps = javaType.skewedColumnValueLocationMaps().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            skewedColumnValues = javaType.skewedColumnValues().map({ args0 -> args0 }),
        )
    }
}
