@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
 * @property databaseName Name of the metadata database where the table metadata resides.
 * @property name Name of the table.
 */
public data class GetCatalogTableTargetTable(
    public val catalogId: String,
    public val databaseName: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTableTargetTable):
            GetCatalogTableTargetTable = GetCatalogTableTargetTable(
            catalogId = javaType.catalogId(),
            databaseName = javaType.databaseName(),
            name = javaType.name(),
        )
    }
}
