@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getConnection.
 * @property arn ARN of the Glue Connection.
 * @property catalogId Catalog ID of the Glue Connection.
 * @property connectionProperties
 * @property connectionType Type of Glue Connection.
 * @property description Description of the connection.
 * @property id
 * @property matchCriterias A list of criteria that can be used in selecting this connection.
 * @property name Name of the Glue Connection.
 * @property physicalConnectionRequirements A map of physical connection requirements, such as VPC and SecurityGroup.
 * @property tags Tags assigned to the resource
 */
public data class GetConnectionResult(
    public val arn: String,
    public val catalogId: String,
    public val connectionProperties: Map<String, String>,
    public val connectionType: String,
    public val description: String,
    public val id: String,
    public val matchCriterias: List<String>,
    public val name: String,
    public val physicalConnectionRequirements: List<GetConnectionPhysicalConnectionRequirement>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetConnectionResult):
            GetConnectionResult = GetConnectionResult(
            arn = javaType.arn(),
            catalogId = javaType.catalogId(),
            connectionProperties = javaType.connectionProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            connectionType = javaType.connectionType(),
            description = javaType.description(),
            id = javaType.id(),
            matchCriterias = javaType.matchCriterias().map({ args0 -> args0 }),
            name = javaType.name(),
            physicalConnectionRequirements = javaType.physicalConnectionRequirements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetConnectionPhysicalConnectionRequirement.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
