@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDataCatalogEncryptionSettings.
 * @property catalogId
 * @property dataCatalogEncryptionSettings The security configuration to set. see Data Catalog Encryption Settings.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetDataCatalogEncryptionSettingsResult(
    public val catalogId: String,
    public val dataCatalogEncryptionSettings:
    List<GetDataCatalogEncryptionSettingsDataCatalogEncryptionSetting>,
    public val id: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetDataCatalogEncryptionSettingsResult):
            GetDataCatalogEncryptionSettingsResult = GetDataCatalogEncryptionSettingsResult(
            catalogId = javaType.catalogId(),
            dataCatalogEncryptionSettings = javaType.dataCatalogEncryptionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSetting.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
