@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args Nested configuration an argument or property of a node. Defined below.
 * @property id Node identifier that is unique within the node's graph.
 * @property lineNumber Line number of the node.
 * @property nodeType Type of node this is.
 */
public data class GetScriptDagNode(
    public val args: List<GetScriptDagNodeArg>,
    public val id: String,
    public val lineNumber: Int? = null,
    public val nodeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetScriptDagNode): GetScriptDagNode =
            GetScriptDagNode(
                args = javaType.args().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.GetScriptDagNodeArg.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                lineNumber = javaType.lineNumber().map({ args0 -> args0 }).orElse(null),
                nodeType = javaType.nodeType(),
            )
    }
}
