@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxConcurrentRuns The maximum number of concurrent runs allowed for a job. The default is 1.
 */
public data class JobExecutionProperty(
    public val maxConcurrentRuns: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.JobExecutionProperty):
            JobExecutionProperty = JobExecutionProperty(
            maxConcurrentRuns = javaType.maxConcurrentRuns().map({ args0 -> args0 }).orElse(null),
        )
    }
}
