@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId A unique identifier for the AWS Glue Data Catalog.
 * @property connectionName The name of the connection to the AWS Glue Data Catalog.
 * @property databaseName A database name in the AWS Glue Data Catalog.
 * @property tableName A table name in the AWS Glue Data Catalog.
 */
public data class MLTransformInputRecordTable(
    public val catalogId: String? = null,
    public val connectionName: String? = null,
    public val databaseName: String,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.MLTransformInputRecordTable):
            MLTransformInputRecordTable = MLTransformInputRecordTable(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName(),
            tableName = javaType.tableName(),
        )
    }
}
