@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accuracyCostTradeOff The value that is selected when tuning your transform for a balance between accuracy and cost.
 * @property enforceProvidedLabels The value to switch on or off to force the output to match the provided labels from users.
 * @property precisionRecallTradeOff The value selected when tuning your transform for a balance between precision and recall.
 * @property primaryKeyColumnName The name of a column that uniquely identifies rows in the source table.
 */
public data class MLTransformParametersFindMatchesParameters(
    public val accuracyCostTradeOff: Double? = null,
    public val enforceProvidedLabels: Boolean? = null,
    public val precisionRecallTradeOff: Double? = null,
    public val primaryKeyColumnName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.MLTransformParametersFindMatchesParameters):
            MLTransformParametersFindMatchesParameters = MLTransformParametersFindMatchesParameters(
            accuracyCostTradeOff = javaType.accuracyCostTradeOff().map({ args0 -> args0 }).orElse(null),
            enforceProvidedLabels = javaType.enforceProvidedLabels().map({ args0 -> args0 }).orElse(null),
            precisionRecallTradeOff = javaType.precisionRecallTradeOff().map({ args0 -> args0 }).orElse(null),
            primaryKeyColumnName = javaType.primaryKeyColumnName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
