@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property bucketColumns A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
 * @property columns A list of the Columns in the table.
 * @property compressed True if the data in the table is compressed, or False if not.
 * @property inputFormat The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
 * @property location The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
 * @property numberOfBuckets Must be specified if the table contains any dimension columns.
 * @property outputFormat The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
 * @property parameters User-supplied properties in key-value form.
 * @property serDeInfo Serialization/deserialization (SerDe) information.
 * @property skewedInfo Information about values that appear very frequently in a column (skewed values).
 * @property sortColumns A list of Order objects specifying the sort order of each bucket in the table.
 * @property storedAsSubDirectories True if the table data is stored in subdirectories, or False if not.
 */
public data class PartitionStorageDescriptor(
    public val bucketColumns: List<String>? = null,
    public val columns: List<PartitionStorageDescriptorColumn>? = null,
    public val compressed: Boolean? = null,
    public val inputFormat: String? = null,
    public val location: String? = null,
    public val numberOfBuckets: Int? = null,
    public val outputFormat: String? = null,
    public val parameters: Map<String, String>? = null,
    public val serDeInfo: PartitionStorageDescriptorSerDeInfo? = null,
    public val skewedInfo: PartitionStorageDescriptorSkewedInfo? = null,
    public val sortColumns: List<PartitionStorageDescriptorSortColumn>? = null,
    public val storedAsSubDirectories: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.PartitionStorageDescriptor):
            PartitionStorageDescriptor = PartitionStorageDescriptor(
            bucketColumns = javaType.bucketColumns().map({ args0 -> args0 }),
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.PartitionStorageDescriptorColumn.Companion.toKotlin(args0)
                })
            }),
            compressed = javaType.compressed().map({ args0 -> args0 }).orElse(null),
            inputFormat = javaType.inputFormat().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            numberOfBuckets = javaType.numberOfBuckets().map({ args0 -> args0 }).orElse(null),
            outputFormat = javaType.outputFormat().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            serDeInfo = javaType.serDeInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.PartitionStorageDescriptorSerDeInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            skewedInfo = javaType.skewedInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.PartitionStorageDescriptorSkewedInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sortColumns = javaType.sortColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.PartitionStorageDescriptorSortColumn.Companion.toKotlin(args0)
                })
            }),
            storedAsSubDirectories = javaType.storedAsSubDirectories().map({ args0 -> args0 }).orElse(null),
        )
    }
}
