@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment Free-form text comment.
 * @property name The name of the Column.
 * @property type The datatype of data in the Column.
 */
public data class PartitionStorageDescriptorColumn(
    public val comment: String? = null,
    public val name: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.PartitionStorageDescriptorColumn):
            PartitionStorageDescriptorColumn = PartitionStorageDescriptorColumn(
            comment = javaType.comment().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
