@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property name Name of the SerDe.
 * @property parameters A map of initialization parameters for the SerDe, in key-value form.
 * @property serializationLibrary Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
 */
public data class PartitionStorageDescriptorSerDeInfo(
    public val name: String? = null,
    public val parameters: Map<String, String>? = null,
    public val serializationLibrary: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.PartitionStorageDescriptorSerDeInfo):
            PartitionStorageDescriptorSerDeInfo = PartitionStorageDescriptorSerDeInfo(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            serializationLibrary = javaType.serializationLibrary().map({ args0 -> args0 }).orElse(null),
        )
    }
}
