@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property column The name of the column.
 * @property sortOrder Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
 */
public data class PartitionStorageDescriptorSortColumn(
    public val column: String,
    public val sortOrder: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.PartitionStorageDescriptorSortColumn):
            PartitionStorageDescriptorSortColumn = PartitionStorageDescriptorSortColumn(
            column = javaType.column(),
            sortOrder = javaType.sortOrder(),
        )
    }
}
