@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cloudwatchEncryption
 * @property jobBookmarksEncryption
 * @property s3Encryption A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
 */
public data class SecurityConfigurationEncryptionConfiguration(
    public val cloudwatchEncryption: SecurityConfigurationEncryptionConfigurationCloudwatchEncryption,
    public val jobBookmarksEncryption:
    SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption,
    public val s3Encryption: SecurityConfigurationEncryptionConfigurationS3Encryption,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.SecurityConfigurationEncryptionConfiguration):
            SecurityConfigurationEncryptionConfiguration = SecurityConfigurationEncryptionConfiguration(
            cloudwatchEncryption = javaType.cloudwatchEncryption().let({ args0 ->
                com.pulumi.aws.glue.kotlin.outputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryption.Companion.toKotlin(args0)
            }),
            jobBookmarksEncryption = javaType.jobBookmarksEncryption().let({ args0 ->
                com.pulumi.aws.glue.kotlin.outputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption.Companion.toKotlin(args0)
            }),
            s3Encryption = javaType.s3Encryption().let({ args0 ->
                com.pulumi.aws.glue.kotlin.outputs.SecurityConfigurationEncryptionConfigurationS3Encryption.Companion.toKotlin(args0)
            }),
        )
    }
}
