@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property jobBookmarksEncryptionMode Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 */
public data class SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption(
    public val jobBookmarksEncryptionMode: String? = null,
    public val kmsKeyArn: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption):
            SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption =
            SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption(
                jobBookmarksEncryptionMode = javaType.jobBookmarksEncryptionMode().map({ args0 ->
                    args0
                }).orElse(null),
                kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
