@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property crawlState The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
 * @property crawlerName The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
 * @property jobName The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
 * @property logicalOperator A logical operator. Defaults to `EQUALS`.
 * @property state The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
 */
public data class TriggerPredicateCondition(
    public val crawlState: String? = null,
    public val crawlerName: String? = null,
    public val jobName: String? = null,
    public val logicalOperator: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.TriggerPredicateCondition):
            TriggerPredicateCondition = TriggerPredicateCondition(
            crawlState = javaType.crawlState().map({ args0 -> args0 }).orElse(null),
            crawlerName = javaType.crawlerName().map({ args0 -> args0 }).orElse(null),
            jobName = javaType.jobName().map({ args0 -> args0 }).orElse(null),
            logicalOperator = javaType.logicalOperator().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
