@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LicenseAssociation].
 */
@PulumiTagMarker
public class LicenseAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LicenseAssociationArgs = LicenseAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LicenseAssociationArgsBuilder.() -> Unit) {
        val builder = LicenseAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LicenseAssociation {
        val builtJavaResource = com.pulumi.aws.grafana.LicenseAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LicenseAssociation(builtJavaResource)
    }
}

/**
 * Provides an Amazon Managed Grafana workspace license association resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.LicenseAssociation;
 * import com.pulumi.aws.grafana.LicenseAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var exampleLicenseAssociation = new LicenseAssociation("exampleLicenseAssociation", LicenseAssociationArgs.builder()
 *             .licenseType("ENTERPRISE_FREE_TRIAL")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Grafana workspace license association using the workspace's `id`. For example:
 * ```sh
 *  $ pulumi import aws:grafana/licenseAssociation:LicenseAssociation example g-2054c75a02
 * ```
 *
 */
public class LicenseAssociation internal constructor(
    override val javaResource: com.pulumi.aws.grafana.LicenseAssociation,
) : KotlinCustomResource(javaResource, LicenseAssociationMapper) {
    /**
     * If `license_type` is set to `ENTERPRISE_FREE_TRIAL`, this is the expiration date of the free trial.
     */
    public val freeTrialExpiration: Output<String>
        get() = javaResource.freeTrialExpiration().applyValue({ args0 -> args0 })

    /**
     * If `license_type` is set to `ENTERPRISE`, this is the expiration date of the enterprise license.
     */
    public val licenseExpiration: Output<String>
        get() = javaResource.licenseExpiration().applyValue({ args0 -> args0 })

    /**
     * The type of license for the workspace license association. Valid values are `ENTERPRISE` and `ENTERPRISE_FREE_TRIAL`.
     */
    public val licenseType: Output<String>
        get() = javaResource.licenseType().applyValue({ args0 -> args0 })

    /**
     * The workspace id.
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object LicenseAssociationMapper : ResourceMapper<LicenseAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.grafana.LicenseAssociation::class == javaResource::class

    override fun map(javaResource: Resource): LicenseAssociation = LicenseAssociation(
        javaResource as
            com.pulumi.aws.grafana.LicenseAssociation,
    )
}

/**
 * @see [LicenseAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LicenseAssociation].
 */
public suspend fun licenseAssociation(
    name: String,
    block: suspend LicenseAssociationResourceBuilder.() -> Unit,
): LicenseAssociation {
    val builder = LicenseAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LicenseAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun licenseAssociation(name: String): LicenseAssociation {
    val builder = LicenseAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
