@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.LicenseAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Managed Grafana workspace license association resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.LicenseAssociation;
 * import com.pulumi.aws.grafana.LicenseAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var exampleLicenseAssociation = new LicenseAssociation("exampleLicenseAssociation", LicenseAssociationArgs.builder()
 *             .licenseType("ENTERPRISE_FREE_TRIAL")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Grafana workspace license association using the workspace's `id`. For example:
 * ```sh
 *  $ pulumi import aws:grafana/licenseAssociation:LicenseAssociation example g-2054c75a02
 * ```
 * @property licenseType The type of license for the workspace license association. Valid values are `ENTERPRISE` and `ENTERPRISE_FREE_TRIAL`.
 * @property workspaceId The workspace id.
 */
public data class LicenseAssociationArgs(
    public val licenseType: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.LicenseAssociationArgs> {
    override fun toJava(): com.pulumi.aws.grafana.LicenseAssociationArgs =
        com.pulumi.aws.grafana.LicenseAssociationArgs.builder()
            .licenseType(licenseType?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LicenseAssociationArgs].
 */
@PulumiTagMarker
public class LicenseAssociationArgsBuilder internal constructor() {
    private var licenseType: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The type of license for the workspace license association. Valid values are `ENTERPRISE` and `ENTERPRISE_FREE_TRIAL`.
     */
    @JvmName("gjpfsdslvxxctdli")
    public suspend fun licenseType(`value`: Output<String>) {
        this.licenseType = value
    }

    /**
     * @param value The workspace id.
     */
    @JvmName("ijfmhiaivgsefyip")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The type of license for the workspace license association. Valid values are `ENTERPRISE` and `ENTERPRISE_FREE_TRIAL`.
     */
    @JvmName("wbchaexfesjfvvag")
    public suspend fun licenseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The workspace id.
     */
    @JvmName("wseplycocctdcvro")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): LicenseAssociationArgs = LicenseAssociationArgs(
        licenseType = licenseType,
        workspaceId = workspaceId,
    )
}
