@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RoleAssociation].
 */
@PulumiTagMarker
public class RoleAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleAssociationArgs = RoleAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleAssociationArgsBuilder.() -> Unit) {
        val builder = RoleAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoleAssociation {
        val builtJavaResource = com.pulumi.aws.grafana.RoleAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RoleAssociation(builtJavaResource)
    }
}

/**
 * Provides an Amazon Managed Grafana workspace role association resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.RoleAssociation;
 * import com.pulumi.aws.grafana.RoleAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var exampleRoleAssociation = new RoleAssociation("exampleRoleAssociation", RoleAssociationArgs.builder()
 *             .role("ADMIN")
 *             .userIds(
 *                 "USER_ID_1",
 *                 "USER_ID_2")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 */
public class RoleAssociation internal constructor(
    override val javaResource: com.pulumi.aws.grafana.RoleAssociation,
) : KotlinCustomResource(javaResource, RoleAssociationMapper) {
    /**
     * The AWS SSO group ids to be assigned the role given in `role`.
     */
    public val groupIds: Output<List<String>>?
        get() = javaResource.groupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The AWS SSO user ids to be assigned the role given in `role`.
     */
    public val userIds: Output<List<String>>?
        get() = javaResource.userIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The workspace id.
     * The following arguments are optional:
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object RoleAssociationMapper : ResourceMapper<RoleAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.grafana.RoleAssociation::class == javaResource::class

    override fun map(javaResource: Resource): RoleAssociation = RoleAssociation(
        javaResource as
            com.pulumi.aws.grafana.RoleAssociation,
    )
}

/**
 * @see [RoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleAssociation].
 */
public suspend fun roleAssociation(
    name: String,
    block: suspend RoleAssociationResourceBuilder.() -> Unit,
): RoleAssociation {
    val builder = RoleAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleAssociation(name: String): RoleAssociation {
    val builder = RoleAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
