@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.RoleAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Managed Grafana workspace role association resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.RoleAssociation;
 * import com.pulumi.aws.grafana.RoleAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var exampleRoleAssociation = new RoleAssociation("exampleRoleAssociation", RoleAssociationArgs.builder()
 *             .role("ADMIN")
 *             .userIds(
 *                 "USER_ID_1",
 *                 "USER_ID_2")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * @property groupIds The AWS SSO group ids to be assigned the role given in `role`.
 * @property role The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
 * @property userIds The AWS SSO user ids to be assigned the role given in `role`.
 * @property workspaceId The workspace id.
 * The following arguments are optional:
 */
public data class RoleAssociationArgs(
    public val groupIds: Output<List<String>>? = null,
    public val role: Output<String>? = null,
    public val userIds: Output<List<String>>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.RoleAssociationArgs> {
    override fun toJava(): com.pulumi.aws.grafana.RoleAssociationArgs =
        com.pulumi.aws.grafana.RoleAssociationArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .role(role?.applyValue({ args0 -> args0 }))
            .userIds(userIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleAssociationArgs].
 */
@PulumiTagMarker
public class RoleAssociationArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var role: Output<String>? = null

    private var userIds: Output<List<String>>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("xhabjridptddqkob")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("pfycypixpexmuthj")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("tjjxjwsntivhwcje")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
     */
    @JvmName("ijhkukifrfrljuvk")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("wtddnhytljhwbobj")
    public suspend fun userIds(`value`: Output<List<String>>) {
        this.userIds = value
    }

    @JvmName("inrkvyoojqdwyxtg")
    public suspend fun userIds(vararg values: Output<String>) {
        this.userIds = Output.all(values.asList())
    }

    /**
     * @param values The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("fuedjouycildlygt")
    public suspend fun userIds(values: List<Output<String>>) {
        this.userIds = Output.all(values)
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("mniteinprhhybcit")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("qgelounlufabvvej")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("racbmodfakukgjah")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
     */
    @JvmName("cwiaxafrwroatvqr")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("vlluroustbuquyak")
    public suspend fun userIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param values The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("mpubvemdbxyqouxy")
    public suspend fun userIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("bieqpjdnupsuqcfr")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): RoleAssociationArgs = RoleAssociationArgs(
        groupIds = groupIds,
        role = role,
        userIds = userIds,
        workspaceId = workspaceId,
    )
}
