@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.WorkspaceApiKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Managed Grafana workspace API Key resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.grafana.WorkspaceApiKey;
 * import com.pulumi.aws.grafana.WorkspaceApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new WorkspaceApiKey("key", WorkspaceApiKeyArgs.builder()
 *             .keyName("test-key")
 *             .keyRole("VIEWER")
 *             .secondsToLive(3600)
 *             .workspaceId(aws_grafana_workspace.test().id())
 *             .build());
 *     }
 * }
 * ```
 * @property keyName Specifies the name of the API key. Key names must be unique to the workspace.
 * @property keyRole Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
 * @property secondsToLive Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
 * @property workspaceId The ID of the workspace that the API key is valid for.
 */
public data class WorkspaceApiKeyArgs(
    public val keyName: Output<String>? = null,
    public val keyRole: Output<String>? = null,
    public val secondsToLive: Output<Int>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.WorkspaceApiKeyArgs> {
    override fun toJava(): com.pulumi.aws.grafana.WorkspaceApiKeyArgs =
        com.pulumi.aws.grafana.WorkspaceApiKeyArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyRole(keyRole?.applyValue({ args0 -> args0 }))
            .secondsToLive(secondsToLive?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceApiKeyArgs].
 */
@PulumiTagMarker
public class WorkspaceApiKeyArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyRole: Output<String>? = null

    private var secondsToLive: Output<Int>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Specifies the name of the API key. Key names must be unique to the workspace.
     */
    @JvmName("xvwcijyvnikyxrql")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
     */
    @JvmName("ngebojriqffihlaa")
    public suspend fun keyRole(`value`: Output<String>) {
        this.keyRole = value
    }

    /**
     * @param value Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
     */
    @JvmName("guyigurirmunpsvn")
    public suspend fun secondsToLive(`value`: Output<Int>) {
        this.secondsToLive = value
    }

    /**
     * @param value The ID of the workspace that the API key is valid for.
     */
    @JvmName("parirtsapqedwkmr")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Specifies the name of the API key. Key names must be unique to the workspace.
     */
    @JvmName("dfibkelmtcpvsxmh")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
     */
    @JvmName("emyoxraxsdmjndmn")
    public suspend fun keyRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyRole = mapped
    }

    /**
     * @param value Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
     */
    @JvmName("qyjxnjfrtmwxdvgt")
    public suspend fun secondsToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondsToLive = mapped
    }

    /**
     * @param value The ID of the workspace that the API key is valid for.
     */
    @JvmName("pemuqmjeuucewmcg")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceApiKeyArgs = WorkspaceApiKeyArgs(
        keyName = keyName,
        keyRole = keyRole,
        secondsToLive = secondsToLive,
        workspaceId = workspaceId,
    )
}
