@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.WorkspaceArgs.builder
import com.pulumi.aws.grafana.kotlin.inputs.WorkspaceNetworkAccessControlArgs
import com.pulumi.aws.grafana.kotlin.inputs.WorkspaceNetworkAccessControlArgsBuilder
import com.pulumi.aws.grafana.kotlin.inputs.WorkspaceVpcConfigurationArgs
import com.pulumi.aws.grafana.kotlin.inputs.WorkspaceVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Managed Grafana workspace resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Grafana Workspace using the workspace's `id`. For example:
 * ```sh
 *  $ pulumi import aws:grafana/workspace:Workspace example g-2054c75a02
 * ```
 * @property accountAccessType The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
 * @property authenticationProviders The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
 * @property configuration The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
 * @property dataSources The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `XRAY`
 * @property description The workspace description.
 * @property grafanaVersion Specifies the version of Grafana to support in the new workspace. Supported values are `8.4` and `9.4`. If not specified, defaults to `8.4`.
 * @property name The Grafana workspace name.
 * @property networkAccessControl Configuration for network access to your workspace.See Network Access Control below.
 * @property notificationDestinations The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
 * @property organizationRoleName The role name that the workspace uses to access resources through Amazon Organizations.
 * @property organizationalUnits The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
 * @property permissionType The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.
 * The following arguments are optional:
 * @property roleArn The IAM role ARN that the workspace assumes.
 * @property stackSetName The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 * @property vpcConfiguration The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
 */
public data class WorkspaceArgs(
    public val accountAccessType: Output<String>? = null,
    public val authenticationProviders: Output<List<String>>? = null,
    public val configuration: Output<String>? = null,
    public val dataSources: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val grafanaVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkAccessControl: Output<WorkspaceNetworkAccessControlArgs>? = null,
    public val notificationDestinations: Output<List<String>>? = null,
    public val organizationRoleName: Output<String>? = null,
    public val organizationalUnits: Output<List<String>>? = null,
    public val permissionType: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val stackSetName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfiguration: Output<WorkspaceVpcConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.WorkspaceArgs> {
    override fun toJava(): com.pulumi.aws.grafana.WorkspaceArgs =
        com.pulumi.aws.grafana.WorkspaceArgs.builder()
            .accountAccessType(accountAccessType?.applyValue({ args0 -> args0 }))
            .authenticationProviders(
                authenticationProviders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .configuration(configuration?.applyValue({ args0 -> args0 }))
            .dataSources(dataSources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .grafanaVersion(grafanaVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkAccessControl(
                networkAccessControl?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .notificationDestinations(
                notificationDestinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .organizationRoleName(organizationRoleName?.applyValue({ args0 -> args0 }))
            .organizationalUnits(organizationalUnits?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .permissionType(permissionType?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .stackSetName(stackSetName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var accountAccessType: Output<String>? = null

    private var authenticationProviders: Output<List<String>>? = null

    private var configuration: Output<String>? = null

    private var dataSources: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var grafanaVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var networkAccessControl: Output<WorkspaceNetworkAccessControlArgs>? = null

    private var notificationDestinations: Output<List<String>>? = null

    private var organizationRoleName: Output<String>? = null

    private var organizationalUnits: Output<List<String>>? = null

    private var permissionType: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var stackSetName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfiguration: Output<WorkspaceVpcConfigurationArgs>? = null

    /**
     * @param value The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
     */
    @JvmName("mvpxjypugnydbsdv")
    public suspend fun accountAccessType(`value`: Output<String>) {
        this.accountAccessType = value
    }

    /**
     * @param value The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
     */
    @JvmName("nwafsemjwgjmqyxq")
    public suspend fun authenticationProviders(`value`: Output<List<String>>) {
        this.authenticationProviders = value
    }

    @JvmName("htyjipvteycrptgf")
    public suspend fun authenticationProviders(vararg values: Output<String>) {
        this.authenticationProviders = Output.all(values.asList())
    }

    /**
     * @param values The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
     */
    @JvmName("haxhsojsywijwprc")
    public suspend fun authenticationProviders(values: List<Output<String>>) {
        this.authenticationProviders = Output.all(values)
    }

    /**
     * @param value The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
     */
    @JvmName("sxthnbjwvdhbfeic")
    public suspend fun configuration(`value`: Output<String>) {
        this.configuration = value
    }

    /**
     * @param value The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `XRAY`
     */
    @JvmName("fvaolrvmhhyfwsml")
    public suspend fun dataSources(`value`: Output<List<String>>) {
        this.dataSources = value
    }

    @JvmName("xkhhgitpaljnumwx")
    public suspend fun dataSources(vararg values: Output<String>) {
        this.dataSources = Output.all(values.asList())
    }

    /**
     * @param values The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `XRAY`
     */
    @JvmName("nhnqjhakbcjsysps")
    public suspend fun dataSources(values: List<Output<String>>) {
        this.dataSources = Output.all(values)
    }

    /**
     * @param value The workspace description.
     */
    @JvmName("atnbpkuqguitsdml")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the version of Grafana to support in the new workspace. Supported values are `8.4` and `9.4`. If not specified, defaults to `8.4`.
     */
    @JvmName("twfjgvshdkyaugtf")
    public suspend fun grafanaVersion(`value`: Output<String>) {
        this.grafanaVersion = value
    }

    /**
     * @param value The Grafana workspace name.
     */
    @JvmName("hrgrvynyymrocgtu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for network access to your workspace.See Network Access Control below.
     */
    @JvmName("skqkwpvyxwfjhovv")
    public suspend fun networkAccessControl(`value`: Output<WorkspaceNetworkAccessControlArgs>) {
        this.networkAccessControl = value
    }

    /**
     * @param value The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
     */
    @JvmName("flwnpqhnjxejfgpt")
    public suspend fun notificationDestinations(`value`: Output<List<String>>) {
        this.notificationDestinations = value
    }

    @JvmName("iiuthbgfssycwvkx")
    public suspend fun notificationDestinations(vararg values: Output<String>) {
        this.notificationDestinations = Output.all(values.asList())
    }

    /**
     * @param values The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
     */
    @JvmName("eirtnvricpdgbtuw")
    public suspend fun notificationDestinations(values: List<Output<String>>) {
        this.notificationDestinations = Output.all(values)
    }

    /**
     * @param value The role name that the workspace uses to access resources through Amazon Organizations.
     */
    @JvmName("eyoxoevcramsoeus")
    public suspend fun organizationRoleName(`value`: Output<String>) {
        this.organizationRoleName = value
    }

    /**
     * @param value The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
     */
    @JvmName("mqcftqboojjwkyvy")
    public suspend fun organizationalUnits(`value`: Output<List<String>>) {
        this.organizationalUnits = value
    }

    @JvmName("flprmqbxsnbjprkm")
    public suspend fun organizationalUnits(vararg values: Output<String>) {
        this.organizationalUnits = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
     */
    @JvmName("hgqxafscililjjen")
    public suspend fun organizationalUnits(values: List<Output<String>>) {
        this.organizationalUnits = Output.all(values)
    }

    /**
     * @param value The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.
     * The following arguments are optional:
     */
    @JvmName("ntnrbsjpbnotfecc")
    public suspend fun permissionType(`value`: Output<String>) {
        this.permissionType = value
    }

    /**
     * @param value The IAM role ARN that the workspace assumes.
     */
    @JvmName("mggfqafpaoeycggo")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
     */
    @JvmName("uhwwjfygmfkxmwqx")
    public suspend fun stackSetName(`value`: Output<String>) {
        this.stackSetName = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("kqmagqcwfcabsnpg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
     */
    @JvmName("ukqvxfjfumhinkoq")
    public suspend fun vpcConfiguration(`value`: Output<WorkspaceVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
     */
    @JvmName("ciajalvugxkkjwuq")
    public suspend fun accountAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountAccessType = mapped
    }

    /**
     * @param value The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
     */
    @JvmName("nnvcyeivylcxwhoe")
    public suspend fun authenticationProviders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationProviders = mapped
    }

    /**
     * @param values The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
     */
    @JvmName("jebidrrjdkeriagv")
    public suspend fun authenticationProviders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationProviders = mapped
    }

    /**
     * @param value The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
     */
    @JvmName("bnkgoliqvjcxnnkx")
    public suspend fun configuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `XRAY`
     */
    @JvmName("utnmhridstmhgjpb")
    public suspend fun dataSources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSources = mapped
    }

    /**
     * @param values The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `XRAY`
     */
    @JvmName("pdpgtpwisdpevgcd")
    public suspend fun dataSources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSources = mapped
    }

    /**
     * @param value The workspace description.
     */
    @JvmName("caswnndojsnmhxun")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the version of Grafana to support in the new workspace. Supported values are `8.4` and `9.4`. If not specified, defaults to `8.4`.
     */
    @JvmName("rhugctdsgvgqacxn")
    public suspend fun grafanaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaVersion = mapped
    }

    /**
     * @param value The Grafana workspace name.
     */
    @JvmName("kwjshvuejnhjwbay")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for network access to your workspace.See Network Access Control below.
     */
    @JvmName("pkyxootvilmqbwwx")
    public suspend fun networkAccessControl(`value`: WorkspaceNetworkAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAccessControl = mapped
    }

    /**
     * @param argument Configuration for network access to your workspace.See Network Access Control below.
     */
    @JvmName("mgpcmpgjrgpotrsm")
    public suspend
    fun networkAccessControl(argument: suspend WorkspaceNetworkAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceNetworkAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkAccessControl = mapped
    }

    /**
     * @param value The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
     */
    @JvmName("dclkolavvchcktyj")
    public suspend fun notificationDestinations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationDestinations = mapped
    }

    /**
     * @param values The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
     */
    @JvmName("alecjxdhkdyeqvuc")
    public suspend fun notificationDestinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationDestinations = mapped
    }

    /**
     * @param value The role name that the workspace uses to access resources through Amazon Organizations.
     */
    @JvmName("lsbqlufktryydycv")
    public suspend fun organizationRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationRoleName = mapped
    }

    /**
     * @param value The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
     */
    @JvmName("grmifctnssbkvtll")
    public suspend fun organizationalUnits(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnits = mapped
    }

    /**
     * @param values The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
     */
    @JvmName("rrevjyxfljuslgkt")
    public suspend fun organizationalUnits(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalUnits = mapped
    }

    /**
     * @param value The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.
     * The following arguments are optional:
     */
    @JvmName("cqsfpeptkdeoldyo")
    public suspend fun permissionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionType = mapped
    }

    /**
     * @param value The IAM role ARN that the workspace assumes.
     */
    @JvmName("jghvkqqnahuplris")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
     */
    @JvmName("sgwlvmwdayjwwayk")
    public suspend fun stackSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackSetName = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("arvjasihicsgfyja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("nrnkpiyeijwrdyyy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
     */
    @JvmName("yudavrmasoydinwo")
    public suspend fun vpcConfiguration(`value`: WorkspaceVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
     */
    @JvmName("cmgyeriyuhwbxgpu")
    public suspend
    fun vpcConfiguration(argument: suspend WorkspaceVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceVpcConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        accountAccessType = accountAccessType,
        authenticationProviders = authenticationProviders,
        configuration = configuration,
        dataSources = dataSources,
        description = description,
        grafanaVersion = grafanaVersion,
        name = name,
        networkAccessControl = networkAccessControl,
        notificationDestinations = notificationDestinations,
        organizationRoleName = organizationRoleName,
        organizationalUnits = organizationalUnits,
        permissionType = permissionType,
        roleArn = roleArn,
        stackSetName = stackSetName,
        tags = tags,
        vpcConfiguration = vpcConfiguration,
    )
}
