@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Managed Grafana workspace SAML configuration resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.WorkspaceSamlConfiguration;
 * import com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var exampleWorkspaceSamlConfiguration = new WorkspaceSamlConfiguration("exampleWorkspaceSamlConfiguration", WorkspaceSamlConfigurationArgs.builder()
 *             .editorRoleValues("editor")
 *             .idpMetadataUrl("https://my_idp_metadata.url")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Grafana Workspace SAML configuration using the workspace's `id`. For example:
 * ```sh
 *  $ pulumi import aws:grafana/workspaceSamlConfiguration:WorkspaceSamlConfiguration example g-2054c75a02
 * ```
 * @property adminRoleValues The admin role values.
 * @property allowedOrganizations The allowed organizations.
 * @property editorRoleValues The editor role values.
 * @property emailAssertion The email assertion.
 * @property groupsAssertion The groups assertion.
 * @property idpMetadataUrl The IDP Metadata URL. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
 * @property idpMetadataXml The IDP Metadata XML. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
 * @property loginAssertion The login assertion.
 * @property loginValidityDuration The login validity duration.
 * @property nameAssertion The name assertion.
 * @property orgAssertion The org assertion.
 * @property roleAssertion The role assertion.
 * @property workspaceId The workspace id.
 * The following arguments are optional:
 */
public data class WorkspaceSamlConfigurationArgs(
    public val adminRoleValues: Output<List<String>>? = null,
    public val allowedOrganizations: Output<List<String>>? = null,
    public val editorRoleValues: Output<List<String>>? = null,
    public val emailAssertion: Output<String>? = null,
    public val groupsAssertion: Output<String>? = null,
    public val idpMetadataUrl: Output<String>? = null,
    public val idpMetadataXml: Output<String>? = null,
    public val loginAssertion: Output<String>? = null,
    public val loginValidityDuration: Output<Int>? = null,
    public val nameAssertion: Output<String>? = null,
    public val orgAssertion: Output<String>? = null,
    public val roleAssertion: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs =
        com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs.builder()
            .adminRoleValues(adminRoleValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrganizations(allowedOrganizations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .editorRoleValues(editorRoleValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .emailAssertion(emailAssertion?.applyValue({ args0 -> args0 }))
            .groupsAssertion(groupsAssertion?.applyValue({ args0 -> args0 }))
            .idpMetadataUrl(idpMetadataUrl?.applyValue({ args0 -> args0 }))
            .idpMetadataXml(idpMetadataXml?.applyValue({ args0 -> args0 }))
            .loginAssertion(loginAssertion?.applyValue({ args0 -> args0 }))
            .loginValidityDuration(loginValidityDuration?.applyValue({ args0 -> args0 }))
            .nameAssertion(nameAssertion?.applyValue({ args0 -> args0 }))
            .orgAssertion(orgAssertion?.applyValue({ args0 -> args0 }))
            .roleAssertion(roleAssertion?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceSamlConfigurationArgs].
 */
@PulumiTagMarker
public class WorkspaceSamlConfigurationArgsBuilder internal constructor() {
    private var adminRoleValues: Output<List<String>>? = null

    private var allowedOrganizations: Output<List<String>>? = null

    private var editorRoleValues: Output<List<String>>? = null

    private var emailAssertion: Output<String>? = null

    private var groupsAssertion: Output<String>? = null

    private var idpMetadataUrl: Output<String>? = null

    private var idpMetadataXml: Output<String>? = null

    private var loginAssertion: Output<String>? = null

    private var loginValidityDuration: Output<Int>? = null

    private var nameAssertion: Output<String>? = null

    private var orgAssertion: Output<String>? = null

    private var roleAssertion: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The admin role values.
     */
    @JvmName("ckbjgoglhrlxqqsf")
    public suspend fun adminRoleValues(`value`: Output<List<String>>) {
        this.adminRoleValues = value
    }

    @JvmName("dmwvnquoarlfjmye")
    public suspend fun adminRoleValues(vararg values: Output<String>) {
        this.adminRoleValues = Output.all(values.asList())
    }

    /**
     * @param values The admin role values.
     */
    @JvmName("pcxtnsghohlxvqau")
    public suspend fun adminRoleValues(values: List<Output<String>>) {
        this.adminRoleValues = Output.all(values)
    }

    /**
     * @param value The allowed organizations.
     */
    @JvmName("mlclxbtscapiquwa")
    public suspend fun allowedOrganizations(`value`: Output<List<String>>) {
        this.allowedOrganizations = value
    }

    @JvmName("jnibbssidoxgxanf")
    public suspend fun allowedOrganizations(vararg values: Output<String>) {
        this.allowedOrganizations = Output.all(values.asList())
    }

    /**
     * @param values The allowed organizations.
     */
    @JvmName("odlbgabserpdvqnn")
    public suspend fun allowedOrganizations(values: List<Output<String>>) {
        this.allowedOrganizations = Output.all(values)
    }

    /**
     * @param value The editor role values.
     */
    @JvmName("kcfbxonopmdpndtg")
    public suspend fun editorRoleValues(`value`: Output<List<String>>) {
        this.editorRoleValues = value
    }

    @JvmName("oqcnlsrpkcuiteeq")
    public suspend fun editorRoleValues(vararg values: Output<String>) {
        this.editorRoleValues = Output.all(values.asList())
    }

    /**
     * @param values The editor role values.
     */
    @JvmName("oetrugytakvbleqw")
    public suspend fun editorRoleValues(values: List<Output<String>>) {
        this.editorRoleValues = Output.all(values)
    }

    /**
     * @param value The email assertion.
     */
    @JvmName("qgqlgwynjmvtvowd")
    public suspend fun emailAssertion(`value`: Output<String>) {
        this.emailAssertion = value
    }

    /**
     * @param value The groups assertion.
     */
    @JvmName("gfnkvmebtovoogkw")
    public suspend fun groupsAssertion(`value`: Output<String>) {
        this.groupsAssertion = value
    }

    /**
     * @param value The IDP Metadata URL. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("tmhilnxvqytxxrcd")
    public suspend fun idpMetadataUrl(`value`: Output<String>) {
        this.idpMetadataUrl = value
    }

    /**
     * @param value The IDP Metadata XML. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("mjlehcdynkiapwul")
    public suspend fun idpMetadataXml(`value`: Output<String>) {
        this.idpMetadataXml = value
    }

    /**
     * @param value The login assertion.
     */
    @JvmName("parvkljwkfjrryhb")
    public suspend fun loginAssertion(`value`: Output<String>) {
        this.loginAssertion = value
    }

    /**
     * @param value The login validity duration.
     */
    @JvmName("hjucdawjaogvmsmb")
    public suspend fun loginValidityDuration(`value`: Output<Int>) {
        this.loginValidityDuration = value
    }

    /**
     * @param value The name assertion.
     */
    @JvmName("hbtxkqfwgwtksyyb")
    public suspend fun nameAssertion(`value`: Output<String>) {
        this.nameAssertion = value
    }

    /**
     * @param value The org assertion.
     */
    @JvmName("uqqjolmkeflixycw")
    public suspend fun orgAssertion(`value`: Output<String>) {
        this.orgAssertion = value
    }

    /**
     * @param value The role assertion.
     */
    @JvmName("ajkyuhpbggmfyrop")
    public suspend fun roleAssertion(`value`: Output<String>) {
        this.roleAssertion = value
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("vujguqbuxbhujjkt")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The admin role values.
     */
    @JvmName("tsdkwtfmtapncwqm")
    public suspend fun adminRoleValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminRoleValues = mapped
    }

    /**
     * @param values The admin role values.
     */
    @JvmName("csxradvmxhlneyfn")
    public suspend fun adminRoleValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminRoleValues = mapped
    }

    /**
     * @param value The allowed organizations.
     */
    @JvmName("sxircueomhygvfgm")
    public suspend fun allowedOrganizations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOrganizations = mapped
    }

    /**
     * @param values The allowed organizations.
     */
    @JvmName("khpgvekpwlupgbjh")
    public suspend fun allowedOrganizations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrganizations = mapped
    }

    /**
     * @param value The editor role values.
     */
    @JvmName("idfrbrnafturbsxu")
    public suspend fun editorRoleValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.editorRoleValues = mapped
    }

    /**
     * @param values The editor role values.
     */
    @JvmName("cqfhdjfkobnjalij")
    public suspend fun editorRoleValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.editorRoleValues = mapped
    }

    /**
     * @param value The email assertion.
     */
    @JvmName("mjyowafhovloijgb")
    public suspend fun emailAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAssertion = mapped
    }

    /**
     * @param value The groups assertion.
     */
    @JvmName("jyjafapteckatnxt")
    public suspend fun groupsAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupsAssertion = mapped
    }

    /**
     * @param value The IDP Metadata URL. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("sdvetkqjwnfbsnpn")
    public suspend fun idpMetadataUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpMetadataUrl = mapped
    }

    /**
     * @param value The IDP Metadata XML. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("dpngmlkwluabudxa")
    public suspend fun idpMetadataXml(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpMetadataXml = mapped
    }

    /**
     * @param value The login assertion.
     */
    @JvmName("hwlgiclkwthlixyl")
    public suspend fun loginAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginAssertion = mapped
    }

    /**
     * @param value The login validity duration.
     */
    @JvmName("ilxnsxsxiauxkkey")
    public suspend fun loginValidityDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginValidityDuration = mapped
    }

    /**
     * @param value The name assertion.
     */
    @JvmName("uhotfhporgyxcefs")
    public suspend fun nameAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameAssertion = mapped
    }

    /**
     * @param value The org assertion.
     */
    @JvmName("sxjbxcjapxmdpcvy")
    public suspend fun orgAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orgAssertion = mapped
    }

    /**
     * @param value The role assertion.
     */
    @JvmName("mjbskmysabyidvgu")
    public suspend fun roleAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleAssertion = mapped
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("ekttsevtqnrvwqox")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceSamlConfigurationArgs = WorkspaceSamlConfigurationArgs(
        adminRoleValues = adminRoleValues,
        allowedOrganizations = allowedOrganizations,
        editorRoleValues = editorRoleValues,
        emailAssertion = emailAssertion,
        groupsAssertion = groupsAssertion,
        idpMetadataUrl = idpMetadataUrl,
        idpMetadataXml = idpMetadataXml,
        loginAssertion = loginAssertion,
        loginValidityDuration = loginValidityDuration,
        nameAssertion = nameAssertion,
        orgAssertion = orgAssertion,
        roleAssertion = roleAssertion,
        workspaceId = workspaceId,
    )
}
