@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin.inputs

import com.pulumi.aws.grafana.inputs.WorkspaceNetworkAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property prefixListIds An array of prefix list IDs.
 * @property vpceIds An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
 */
public data class WorkspaceNetworkAccessControlArgs(
    public val prefixListIds: Output<List<String>>,
    public val vpceIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.grafana.inputs.WorkspaceNetworkAccessControlArgs> {
    override fun toJava(): com.pulumi.aws.grafana.inputs.WorkspaceNetworkAccessControlArgs =
        com.pulumi.aws.grafana.inputs.WorkspaceNetworkAccessControlArgs.builder()
            .prefixListIds(prefixListIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpceIds(vpceIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WorkspaceNetworkAccessControlArgs].
 */
@PulumiTagMarker
public class WorkspaceNetworkAccessControlArgsBuilder internal constructor() {
    private var prefixListIds: Output<List<String>>? = null

    private var vpceIds: Output<List<String>>? = null

    /**
     * @param value An array of prefix list IDs.
     */
    @JvmName("psjrduspgolwpylh")
    public suspend fun prefixListIds(`value`: Output<List<String>>) {
        this.prefixListIds = value
    }

    @JvmName("rbapxeujbluwgwbr")
    public suspend fun prefixListIds(vararg values: Output<String>) {
        this.prefixListIds = Output.all(values.asList())
    }

    /**
     * @param values An array of prefix list IDs.
     */
    @JvmName("ipwskfjtniimxpvs")
    public suspend fun prefixListIds(values: List<Output<String>>) {
        this.prefixListIds = Output.all(values)
    }

    /**
     * @param value An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
     */
    @JvmName("wwofuiudwwdvuqdu")
    public suspend fun vpceIds(`value`: Output<List<String>>) {
        this.vpceIds = value
    }

    @JvmName("jlctlxhuwagiknfd")
    public suspend fun vpceIds(vararg values: Output<String>) {
        this.vpceIds = Output.all(values.asList())
    }

    /**
     * @param values An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
     */
    @JvmName("yrttbuourdaeliss")
    public suspend fun vpceIds(values: List<Output<String>>) {
        this.vpceIds = Output.all(values)
    }

    /**
     * @param value An array of prefix list IDs.
     */
    @JvmName("vvnagbhvxltgxmmg")
    public suspend fun prefixListIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param values An array of prefix list IDs.
     */
    @JvmName("vdfrrwdwwiwinmtp")
    public suspend fun prefixListIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param value An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
     */
    @JvmName("pghsouojjihjdgid")
    public suspend fun vpceIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpceIds = mapped
    }

    /**
     * @param values An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
     */
    @JvmName("rnkumvbxxvstmhtl")
    public suspend fun vpceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpceIds = mapped
    }

    internal fun build(): WorkspaceNetworkAccessControlArgs = WorkspaceNetworkAccessControlArgs(
        prefixListIds = prefixListIds ?: throw PulumiNullFieldException("prefixListIds"),
        vpceIds = vpceIds ?: throw PulumiNullFieldException("vpceIds"),
    )
}
