@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
 * @property subnetIds The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
 */
public data class WorkspaceVpcConfiguration(
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.grafana.outputs.WorkspaceVpcConfiguration):
            WorkspaceVpcConfiguration = WorkspaceVpcConfiguration(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
