@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.DetectorFeatureArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.DetectorFeatureAdditionalConfigurationArgs
import com.pulumi.aws.guardduty.kotlin.inputs.DetectorFeatureAdditionalConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a single Amazon GuardDuty [detector feature](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-features-activation-model.html#guardduty-features).
 * > **NOTE:** Deleting this resource does not disable the detector feature, the resource in simply removed from state instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.DetectorFeature;
 * import com.pulumi.aws.guardduty.DetectorFeatureArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorFeatureAdditionalConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Detector("example", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var eksRuntimeMonitoring = new DetectorFeature("eksRuntimeMonitoring", DetectorFeatureArgs.builder()
 *             .detectorId(example.id())
 *             .status("ENABLED")
 *             .additionalConfigurations(DetectorFeatureAdditionalConfigurationArgs.builder()
 *                 .name("EKS_ADDON_MANAGEMENT")
 *                 .status("ENABLED")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property additionalConfigurations Additional feature configuration block. See below.
 * @property detectorId Amazon GuardDuty detector ID.
 * @property name The name of the detector feature. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`.
 * @property status The status of the detector feature. Valid values: `ENABLED`, `DISABLED`.
 */
public data class DetectorFeatureArgs(
    public val additionalConfigurations: Output<List<DetectorFeatureAdditionalConfigurationArgs>>? =
        null,
    public val detectorId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.DetectorFeatureArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.DetectorFeatureArgs =
        com.pulumi.aws.guardduty.DetectorFeatureArgs.builder()
            .additionalConfigurations(
                additionalConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DetectorFeatureArgs].
 */
@PulumiTagMarker
public class DetectorFeatureArgsBuilder internal constructor() {
    private var additionalConfigurations: Output<List<DetectorFeatureAdditionalConfigurationArgs>>? =
        null

    private var detectorId: Output<String>? = null

    private var name: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Additional feature configuration block. See below.
     */
    @JvmName("ckrtgdjjycsdjbjs")
    public suspend
    fun additionalConfigurations(`value`: Output<List<DetectorFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = value
    }

    @JvmName("sfmjvssrqirnlnqn")
    public suspend fun additionalConfigurations(
        vararg
        values: Output<DetectorFeatureAdditionalConfigurationArgs>,
    ) {
        this.additionalConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Additional feature configuration block. See below.
     */
    @JvmName("rmhyymblfpeyggki")
    public suspend
    fun additionalConfigurations(values: List<Output<DetectorFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = Output.all(values)
    }

    /**
     * @param value Amazon GuardDuty detector ID.
     */
    @JvmName("mlgwfdtyjhhacfov")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value The name of the detector feature. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`.
     */
    @JvmName("xxflvyaonuskieyc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The status of the detector feature. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("txwearvicunqmilh")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Additional feature configuration block. See below.
     */
    @JvmName("dvvrjggnbbkpnjjr")
    public suspend
    fun additionalConfigurations(`value`: List<DetectorFeatureAdditionalConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block. See below.
     */
    @JvmName("jgpmrwcwutnvvlui")
    public suspend
    fun additionalConfigurations(argument: List<suspend DetectorFeatureAdditionalConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DetectorFeatureAdditionalConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block. See below.
     */
    @JvmName("klxnnjlmrxddydre")
    public suspend fun additionalConfigurations(
        vararg
        argument: suspend DetectorFeatureAdditionalConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DetectorFeatureAdditionalConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block. See below.
     */
    @JvmName("hfpxmhpwpcsbhhdj")
    public suspend
    fun additionalConfigurations(argument: suspend DetectorFeatureAdditionalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DetectorFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param values Additional feature configuration block. See below.
     */
    @JvmName("npfsgljccexjxcks")
    public suspend fun additionalConfigurations(
        vararg
        values: DetectorFeatureAdditionalConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param value Amazon GuardDuty detector ID.
     */
    @JvmName("wjmulkfngajjhtss")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value The name of the detector feature. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`.
     */
    @JvmName("lttbnncjlyscxfno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The status of the detector feature. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("sqjwirhqeraudkqa")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DetectorFeatureArgs = DetectorFeatureArgs(
        additionalConfigurations = additionalConfigurations,
        detectorId = detectorId,
        name = name,
        status = status,
    )
}
