@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.kotlin.outputs.FilterFindingCriteria
import com.pulumi.aws.guardduty.kotlin.outputs.FilterFindingCriteria.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Filter].
 */
@PulumiTagMarker
public class FilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FilterArgs = FilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FilterArgsBuilder.() -> Unit) {
        val builder = FilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Filter {
        val builtJavaResource = com.pulumi.aws.guardduty.Filter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Filter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a GuardDuty filter.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Filter;
 * import com.pulumi.aws.guardduty.FilterArgs;
 * import com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myFilter = new Filter("myFilter", FilterArgs.builder()
 *             .action("ARCHIVE")
 *             .detectorId(aws_guardduty_detector.example().id())
 *             .rank(1)
 *             .findingCriteria(FilterFindingCriteriaArgs.builder()
 *                 .criterions(
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("region")
 *                         .equals("eu-west-1")
 *                         .build(),
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("service.additionalInfo.threatListName")
 *                         .notEquals(
 *                             "some-threat",
 *                             "another-threat")
 *                         .build(),
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("updatedAt")
 *                         .greaterThan("2020-01-01T00:00:00Z")
 *                         .lessThan("2020-02-01T00:00:00Z")
 *                         .build(),
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("severity")
 *                         .greaterThanOrEqual("4")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty filters using the detector ID and filter's name separated by a colon. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/filter:Filter MyFilter 00b00fd5aecc0ab60a708659477e9617:MyFilter
 * ```
 *
 */
public class Filter internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.Filter,
) : KotlinCustomResource(javaResource, FilterMapper) {
    /**
     * Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * The ARN of the GuardDuty filter.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the filter.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of a GuardDuty detector, attached to your account.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })

    /**
     * Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
     */
    public val findingCriteria: Output<FilterFindingCriteria>
        get() = javaResource.findingCriteria().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The name of your filter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
     */
    public val rank: Output<Int>
        get() = javaResource.rank().applyValue({ args0 -> args0 })

    /**
     * The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FilterMapper : ResourceMapper<Filter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.Filter::class == javaResource::class

    override fun map(javaResource: Resource): Filter = Filter(
        javaResource as
            com.pulumi.aws.guardduty.Filter,
    )
}

/**
 * @see [Filter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Filter].
 */
public suspend fun filter(name: String, block: suspend FilterResourceBuilder.() -> Unit): Filter {
    val builder = FilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Filter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun filter(name: String): Filter {
    val builder = FilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
