@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.GuarddutyFunctions.getDetectorPlain
import com.pulumi.aws.guardduty.GuarddutyFunctions.getFindingIdsPlain
import com.pulumi.aws.guardduty.kotlin.inputs.GetDetectorPlainArgs
import com.pulumi.aws.guardduty.kotlin.inputs.GetDetectorPlainArgsBuilder
import com.pulumi.aws.guardduty.kotlin.inputs.GetFindingIdsPlainArgs
import com.pulumi.aws.guardduty.kotlin.inputs.GetFindingIdsPlainArgsBuilder
import com.pulumi.aws.guardduty.kotlin.outputs.GetDetectorResult
import com.pulumi.aws.guardduty.kotlin.outputs.GetFindingIdsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.guardduty.kotlin.outputs.GetDetectorResult.Companion.toKotlin as getDetectorResultToKotlin
import com.pulumi.aws.guardduty.kotlin.outputs.GetFindingIdsResult.Companion.toKotlin as getFindingIdsResultToKotlin

public object GuarddutyFunctions {
    /**
     * Retrieve information about a GuardDuty detector.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.guardduty.GuarddutyFunctions;
     * import com.pulumi.aws.guardduty.inputs.GetDetectorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GuarddutyFunctions.getDetector();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDetector.
     * @return A collection of values returned by getDetector.
     */
    public suspend fun getDetector(argument: GetDetectorPlainArgs): GetDetectorResult =
        getDetectorResultToKotlin(getDetectorPlain(argument.toJava()).await())

    /**
     * @see [getDetector].
     * @param id ID of the detector.
     * @return A collection of values returned by getDetector.
     */
    public suspend fun getDetector(id: String? = null): GetDetectorResult {
        val argument = GetDetectorPlainArgs(
            id = id,
        )
        return getDetectorResultToKotlin(getDetectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getDetector].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;guardduty&#46;kotlin&#46;inputs&#46;GetDetectorPlainArgs].
     * @return A collection of values returned by getDetector.
     */
    public suspend fun getDetector(argument: suspend GetDetectorPlainArgsBuilder.() -> Unit):
        GetDetectorResult {
        val builder = GetDetectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDetectorResultToKotlin(getDetectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS GuardDuty Finding Ids.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.guardduty.GuarddutyFunctions;
     * import com.pulumi.aws.guardduty.inputs.GetFindingIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GuarddutyFunctions.getFindingIds(GetFindingIdsArgs.builder()
     *             .detectorId(aws_guardduty_detector.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getFindingIds.
     * @return A collection of values returned by getFindingIds.
     */
    public suspend fun getFindingIds(argument: GetFindingIdsPlainArgs): GetFindingIdsResult =
        getFindingIdsResultToKotlin(getFindingIdsPlain(argument.toJava()).await())

    /**
     * @see [getFindingIds].
     * @param detectorId ID of the GuardDuty detector.
     * @return A collection of values returned by getFindingIds.
     */
    public suspend fun getFindingIds(detectorId: String): GetFindingIdsResult {
        val argument = GetFindingIdsPlainArgs(
            detectorId = detectorId,
        )
        return getFindingIdsResultToKotlin(getFindingIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFindingIds].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;guardduty&#46;kotlin&#46;inputs&#46;GetFindingIdsPlainArgs].
     * @return A collection of values returned by getFindingIds.
     */
    public suspend fun getFindingIds(argument: suspend GetFindingIdsPlainArgsBuilder.() -> Unit):
        GetFindingIdsResult {
        val builder = GetFindingIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFindingIdsResultToKotlin(getFindingIdsPlain(builtArgument.toJava()).await())
    }
}
