@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IPSet].
 */
@PulumiTagMarker
public class IPSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IPSetArgs = IPSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IPSetArgsBuilder.() -> Unit) {
        val builder = IPSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IPSet {
        val builtJavaResource = com.pulumi.aws.guardduty.IPSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IPSet(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a GuardDuty IPSet.
 * > **Note:** Currently in GuardDuty, users from member accounts cannot upload and further manage IPSets. IPSets that are uploaded by the primary account are imposed on GuardDuty functionality in its member accounts. See the [GuardDuty API Documentation](https://docs.aws.amazon.com/guardduty/latest/ug/create-ip-set.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.guardduty.IPSet;
 * import com.pulumi.aws.guardduty.IPSetArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Detector("primary", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var bucket = new BucketV2("bucket");
 *         var myIPSet = new BucketObjectv2("myIPSet", BucketObjectv2Args.builder()
 *             .content("""
 * 10.0.0.0/8
 *             """)
 *             .bucket(bucket.id())
 *             .key("MyIPSet")
 *             .build());
 *         var example = new IPSet("example", IPSetArgs.builder()
 *             .activate(true)
 *             .detectorId(primary.id())
 *             .format("TXT")
 *             .location(Output.tuple(myIPSet.bucket(), myIPSet.key()).applyValue(values -> {
 *                 var bucket = values.t1;
 *                 var key = values.t2;
 *                 return String.format("https://s3.amazonaws.com/%s/%s", bucket,key);
 *             }))
 *             .build());
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty IPSet using the primary GuardDuty detector ID and IPSet ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/iPSet:IPSet MyIPSet 00b00fd5aecc0ab60a708659477e9617:123456789012
 * ```
 *
 */
public class IPSet internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.IPSet,
) : KotlinCustomResource(javaResource, IPSetMapper) {
    /**
     * Specifies whether GuardDuty is to start using the uploaded IPSet.
     */
    public val activate: Output<Boolean>
        get() = javaResource.activate().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the GuardDuty IPSet.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The detector ID of the GuardDuty.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })

    /**
     * The format of the file that contains the IPSet. Valid values: `TXT` | `STIX` | `OTX_CSV` | `ALIEN_VAULT` | `PROOF_POINT` | `FIRE_EYE`
     */
    public val format: Output<String>
        get() = javaResource.format().applyValue({ args0 -> args0 })

    /**
     * The URI of the file that contains the IPSet.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The friendly name to identify the IPSet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object IPSetMapper : ResourceMapper<IPSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.IPSet::class == javaResource::class

    override fun map(javaResource: Resource): IPSet = IPSet(
        javaResource as
            com.pulumi.aws.guardduty.IPSet,
    )
}

/**
 * @see [IPSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IPSet].
 */
public suspend fun ipSet(name: String, block: suspend IPSetResourceBuilder.() -> Unit): IPSet {
    val builder = IPSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IPSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipSet(name: String): IPSet {
    val builder = IPSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
