@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InviteAccepter].
 */
@PulumiTagMarker
public class InviteAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InviteAccepterArgs = InviteAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InviteAccepterArgsBuilder.() -> Unit) {
        val builder = InviteAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InviteAccepter {
        val builtJavaResource = com.pulumi.aws.guardduty.InviteAccepter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InviteAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to accept a pending GuardDuty invite on creation, ensure the detector has the correct primary account on read, and disassociate with the primary account upon removal.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.Member;
 * import com.pulumi.aws.guardduty.MemberArgs;
 * import com.pulumi.aws.guardduty.InviteAccepter;
 * import com.pulumi.aws.guardduty.InviteAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Provider("primary");
 *         var member = new Provider("member");
 *         var primaryDetector = new Detector("primaryDetector", DetectorArgs.Empty, CustomResourceOptions.builder()
 *             .provider(aws.primary())
 *             .build());
 *         var memberDetector = new Detector("memberDetector", DetectorArgs.Empty, CustomResourceOptions.builder()
 *             .provider(aws.member())
 *             .build());
 *         var memberMember = new Member("memberMember", MemberArgs.builder()
 *             .accountId(memberDetector.accountId())
 *             .detectorId(primaryDetector.id())
 *             .email("required@example.com")
 *             .invite(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var memberInviteAccepter = new InviteAccepter("memberInviteAccepter", InviteAccepterArgs.builder()
 *             .detectorId(memberDetector.id())
 *             .masterAccountId(primaryDetector.accountId())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.member())
 *                 .dependsOn(memberMember)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_guardduty_invite_accepter` using the member GuardDuty detector ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/inviteAccepter:InviteAccepter member 00b00fd5aecc0ab60a708659477e9617
 * ```
 *
 */
public class InviteAccepter internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.InviteAccepter,
) : KotlinCustomResource(javaResource, InviteAccepterMapper) {
    /**
     * The detector ID of the member GuardDuty account.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })

    /**
     * AWS account ID for primary account.
     */
    public val masterAccountId: Output<String>
        get() = javaResource.masterAccountId().applyValue({ args0 -> args0 })
}

public object InviteAccepterMapper : ResourceMapper<InviteAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.InviteAccepter::class == javaResource::class

    override fun map(javaResource: Resource): InviteAccepter = InviteAccepter(
        javaResource as
            com.pulumi.aws.guardduty.InviteAccepter,
    )
}

/**
 * @see [InviteAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InviteAccepter].
 */
public suspend fun inviteAccepter(
    name: String,
    block: suspend InviteAccepterResourceBuilder.() -> Unit,
): InviteAccepter {
    val builder = InviteAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InviteAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inviteAccepter(name: String): InviteAccepter {
    val builder = InviteAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
