@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.InviteAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to accept a pending GuardDuty invite on creation, ensure the detector has the correct primary account on read, and disassociate with the primary account upon removal.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.Member;
 * import com.pulumi.aws.guardduty.MemberArgs;
 * import com.pulumi.aws.guardduty.InviteAccepter;
 * import com.pulumi.aws.guardduty.InviteAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Provider("primary");
 *         var member = new Provider("member");
 *         var primaryDetector = new Detector("primaryDetector", DetectorArgs.Empty, CustomResourceOptions.builder()
 *             .provider(aws.primary())
 *             .build());
 *         var memberDetector = new Detector("memberDetector", DetectorArgs.Empty, CustomResourceOptions.builder()
 *             .provider(aws.member())
 *             .build());
 *         var memberMember = new Member("memberMember", MemberArgs.builder()
 *             .accountId(memberDetector.accountId())
 *             .detectorId(primaryDetector.id())
 *             .email("required@example.com")
 *             .invite(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var memberInviteAccepter = new InviteAccepter("memberInviteAccepter", InviteAccepterArgs.builder()
 *             .detectorId(memberDetector.id())
 *             .masterAccountId(primaryDetector.accountId())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.member())
 *                 .dependsOn(memberMember)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_guardduty_invite_accepter` using the member GuardDuty detector ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/inviteAccepter:InviteAccepter member 00b00fd5aecc0ab60a708659477e9617
 * ```
 * @property detectorId The detector ID of the member GuardDuty account.
 * @property masterAccountId AWS account ID for primary account.
 */
public data class InviteAccepterArgs(
    public val detectorId: Output<String>? = null,
    public val masterAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.InviteAccepterArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.InviteAccepterArgs =
        com.pulumi.aws.guardduty.InviteAccepterArgs.builder()
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .masterAccountId(masterAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InviteAccepterArgs].
 */
@PulumiTagMarker
public class InviteAccepterArgsBuilder internal constructor() {
    private var detectorId: Output<String>? = null

    private var masterAccountId: Output<String>? = null

    /**
     * @param value The detector ID of the member GuardDuty account.
     */
    @JvmName("ablcwvpixkulpxdb")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value AWS account ID for primary account.
     */
    @JvmName("rvnemmsympluatvr")
    public suspend fun masterAccountId(`value`: Output<String>) {
        this.masterAccountId = value
    }

    /**
     * @param value The detector ID of the member GuardDuty account.
     */
    @JvmName("awqlxggvnmuctwdp")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value AWS account ID for primary account.
     */
    @JvmName("rcrveyxdgrdkgjft")
    public suspend fun masterAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterAccountId = mapped
    }

    internal fun build(): InviteAccepterArgs = InviteAccepterArgs(
        detectorId = detectorId,
        masterAccountId = masterAccountId,
    )
}
