@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.MemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a GuardDuty member. To accept invitations in member accounts, see the `aws.guardduty.InviteAccepter` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.Member;
 * import com.pulumi.aws.guardduty.MemberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Detector("primary", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var memberDetector = new Detector("memberDetector", DetectorArgs.builder()
 *             .enable(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.dev())
 *                 .build());
 *         var memberMember = new Member("memberMember", MemberArgs.builder()
 *             .accountId(memberDetector.accountId())
 *             .detectorId(primary.id())
 *             .email("required@example.com")
 *             .invite(true)
 *             .invitationMessage("please accept guardduty invitation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty members using the primary GuardDuty detector ID and member AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/member:Member MyMember 00b00fd5aecc0ab60a708659477e9617:123456789012
 * ```
 * @property accountId AWS account ID for member account.
 * @property detectorId The detector ID of the GuardDuty account where you want to create member accounts.
 * @property disableEmailNotification Boolean whether an email notification is sent to the accounts. Defaults to `false`.
 * @property email Email address for member account.
 * @property invitationMessage Message for invitation.
 * @property invite Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
 */
public data class MemberArgs(
    public val accountId: Output<String>? = null,
    public val detectorId: Output<String>? = null,
    public val disableEmailNotification: Output<Boolean>? = null,
    public val email: Output<String>? = null,
    public val invitationMessage: Output<String>? = null,
    public val invite: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.MemberArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.MemberArgs =
        com.pulumi.aws.guardduty.MemberArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .disableEmailNotification(disableEmailNotification?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .invitationMessage(invitationMessage?.applyValue({ args0 -> args0 }))
            .invite(invite?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemberArgs].
 */
@PulumiTagMarker
public class MemberArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var detectorId: Output<String>? = null

    private var disableEmailNotification: Output<Boolean>? = null

    private var email: Output<String>? = null

    private var invitationMessage: Output<String>? = null

    private var invite: Output<Boolean>? = null

    /**
     * @param value AWS account ID for member account.
     */
    @JvmName("iyqxrxeefvioyisr")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The detector ID of the GuardDuty account where you want to create member accounts.
     */
    @JvmName("chyfojenpymphwcx")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value Boolean whether an email notification is sent to the accounts. Defaults to `false`.
     */
    @JvmName("jijslfujokclrohs")
    public suspend fun disableEmailNotification(`value`: Output<Boolean>) {
        this.disableEmailNotification = value
    }

    /**
     * @param value Email address for member account.
     */
    @JvmName("ugpwqsfnqpjbgsel")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Message for invitation.
     */
    @JvmName("nvcijdkiyxlwagro")
    public suspend fun invitationMessage(`value`: Output<String>) {
        this.invitationMessage = value
    }

    /**
     * @param value Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
     */
    @JvmName("ufybrsxffjpcfitn")
    public suspend fun invite(`value`: Output<Boolean>) {
        this.invite = value
    }

    /**
     * @param value AWS account ID for member account.
     */
    @JvmName("xhmuldxstwewkaav")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The detector ID of the GuardDuty account where you want to create member accounts.
     */
    @JvmName("stxvdpnavqxotlug")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value Boolean whether an email notification is sent to the accounts. Defaults to `false`.
     */
    @JvmName("rpkvnoccddotweap")
    public suspend fun disableEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableEmailNotification = mapped
    }

    /**
     * @param value Email address for member account.
     */
    @JvmName("vtaswuatgkwskexf")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Message for invitation.
     */
    @JvmName("cmhhhqwhsnxwkaay")
    public suspend fun invitationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invitationMessage = mapped
    }

    /**
     * @param value Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
     */
    @JvmName("qecagirvallvwxrd")
    public suspend fun invite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invite = mapped
    }

    internal fun build(): MemberArgs = MemberArgs(
        accountId = accountId,
        detectorId = detectorId,
        disableEmailNotification = disableEmailNotification,
        email = email,
        invitationMessage = invitationMessage,
        invite = invite,
    )
}
