@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationAdminAccount].
 */
@PulumiTagMarker
public class OrganizationAdminAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationAdminAccountArgs = OrganizationAdminAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationAdminAccountArgsBuilder.() -> Unit) {
        val builder = OrganizationAdminAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OrganizationAdminAccount {
        val builtJavaResource =
            com.pulumi.aws.guardduty.OrganizationAdminAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationAdminAccount(builtJavaResource)
    }
}

/**
 * Manages a GuardDuty Organization Admin Account. The AWS account utilizing this resource must be an Organizations primary account. More information about Organizations support in GuardDuty can be found in the [GuardDuty User Guide](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.OrganizationAdminAccount;
 * import com.pulumi.aws.guardduty.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("guardduty.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleDetector = new Detector("exampleDetector");
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty Organization Admin Account using the AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/organizationAdminAccount:OrganizationAdminAccount example 123456789012
 * ```
 *
 */
public class OrganizationAdminAccount internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.OrganizationAdminAccount,
) : KotlinCustomResource(javaResource, OrganizationAdminAccountMapper) {
    /**
     * AWS account identifier to designate as a delegated administrator for GuardDuty.
     */
    public val adminAccountId: Output<String>
        get() = javaResource.adminAccountId().applyValue({ args0 -> args0 })
}

public object OrganizationAdminAccountMapper : ResourceMapper<OrganizationAdminAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.OrganizationAdminAccount::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationAdminAccount =
        OrganizationAdminAccount(javaResource as com.pulumi.aws.guardduty.OrganizationAdminAccount)
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationAdminAccount].
 */
public suspend fun organizationAdminAccount(
    name: String,
    block: suspend OrganizationAdminAccountResourceBuilder.() -> Unit,
): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationAdminAccount(name: String): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
