@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.OrganizationAdminAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a GuardDuty Organization Admin Account. The AWS account utilizing this resource must be an Organizations primary account. More information about Organizations support in GuardDuty can be found in the [GuardDuty User Guide](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.OrganizationAdminAccount;
 * import com.pulumi.aws.guardduty.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("guardduty.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleDetector = new Detector("exampleDetector");
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty Organization Admin Account using the AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/organizationAdminAccount:OrganizationAdminAccount example 123456789012
 * ```
 * @property adminAccountId AWS account identifier to designate as a delegated administrator for GuardDuty.
 */
public data class OrganizationAdminAccountArgs(
    public val adminAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.OrganizationAdminAccountArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.OrganizationAdminAccountArgs =
        com.pulumi.aws.guardduty.OrganizationAdminAccountArgs.builder()
            .adminAccountId(adminAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationAdminAccountArgs].
 */
@PulumiTagMarker
public class OrganizationAdminAccountArgsBuilder internal constructor() {
    private var adminAccountId: Output<String>? = null

    /**
     * @param value AWS account identifier to designate as a delegated administrator for GuardDuty.
     */
    @JvmName("juhduvyismtqcuig")
    public suspend fun adminAccountId(`value`: Output<String>) {
        this.adminAccountId = value
    }

    /**
     * @param value AWS account identifier to designate as a delegated administrator for GuardDuty.
     */
    @JvmName("qsfkxkihnstxomoi")
    public suspend fun adminAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminAccountId = mapped
    }

    internal fun build(): OrganizationAdminAccountArgs = OrganizationAdminAccountArgs(
        adminAccountId = adminAccountId,
    )
}
