@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasources
import com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasources.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationConfiguration].
 */
@PulumiTagMarker
public class OrganizationConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationConfigurationArgs = OrganizationConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationConfigurationArgsBuilder.() -> Unit) {
        val builder = OrganizationConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OrganizationConfiguration {
        val builtJavaResource =
            com.pulumi.aws.guardduty.OrganizationConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationConfiguration(builtJavaResource)
    }
}

/**
 * Manages the GuardDuty Organization Configuration in the current AWS Region. The AWS account utilizing this resource must have been assigned as a delegated Organization administrator account, e.g., via the `aws.guardduty.OrganizationAdminAccount` resource. More information about Organizations support in GuardDuty can be found in the [GuardDuty User Guide](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).
 * > **NOTE:** This is an advanced resource. The provider will automatically assume management of the GuardDuty Organization Configuration without import and perform no actions on removal from the resource configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.OrganizationConfiguration;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesS3LogsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDetector = new Detector("exampleDetector", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnableOrganizationMembers("ALL")
 *             .detectorId(exampleDetector.id())
 *             .datasources(OrganizationConfigurationDatasourcesArgs.builder()
 *                 .s3Logs(OrganizationConfigurationDatasourcesS3LogsArgs.builder()
 *                     .autoEnable(true)
 *                     .build())
 *                 .kubernetes(OrganizationConfigurationDatasourcesKubernetesArgs.builder()
 *                     .auditLogs(OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs.builder()
 *                         .enable(true)
 *                         .build())
 *                     .build())
 *                 .malwareProtection(OrganizationConfigurationDatasourcesMalwareProtectionArgs.builder()
 *                     .scanEc2InstanceWithFindings(OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder()
 *                         .ebsVolumes(OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs.builder()
 *                             .autoEnable(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty Organization Configurations using the GuardDuty Detector ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/organizationConfiguration:OrganizationConfiguration example 00b00fd5aecc0ab60a708659477e9617
 * ```
 *
 */
public class OrganizationConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.OrganizationConfiguration,
) : KotlinCustomResource(javaResource, OrganizationConfigurationMapper) {
    /**
     * *Deprecated:* Use `auto_enable_organization_members` instead. When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s GuardDuty delegated administrator and GuardDuty is enabled in that AWS Region.
     */
    @Deprecated(
        message = """
  Use auto_enable_organization_members instead
  """,
    )
    public val autoEnable: Output<Boolean>
        get() = javaResource.autoEnable().applyValue({ args0 -> args0 })

    /**
     * Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. Valid values are `ALL`, `NEW`, `NONE`.
     */
    public val autoEnableOrganizationMembers: Output<String>
        get() = javaResource.autoEnableOrganizationMembers().applyValue({ args0 -> args0 })

    /**
     * Configuration for the collected datasources.
     */
    public val datasources: Output<OrganizationConfigurationDatasources>
        get() = javaResource.datasources().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The detector ID of the GuardDuty account.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })
}

public object OrganizationConfigurationMapper : ResourceMapper<OrganizationConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.OrganizationConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationConfiguration =
        OrganizationConfiguration(javaResource as com.pulumi.aws.guardduty.OrganizationConfiguration)
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationConfiguration].
 */
public suspend fun organizationConfiguration(
    name: String,
    block: suspend OrganizationConfigurationResourceBuilder.() -> Unit,
): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationConfiguration(name: String): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
