@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.OrganizationConfigurationArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.OrganizationConfigurationDatasourcesArgs
import com.pulumi.aws.guardduty.kotlin.inputs.OrganizationConfigurationDatasourcesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages the GuardDuty Organization Configuration in the current AWS Region. The AWS account utilizing this resource must have been assigned as a delegated Organization administrator account, e.g., via the `aws.guardduty.OrganizationAdminAccount` resource. More information about Organizations support in GuardDuty can be found in the [GuardDuty User Guide](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).
 * > **NOTE:** This is an advanced resource. The provider will automatically assume management of the GuardDuty Organization Configuration without import and perform no actions on removal from the resource configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.OrganizationConfiguration;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesS3LogsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDetector = new Detector("exampleDetector", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnableOrganizationMembers("ALL")
 *             .detectorId(exampleDetector.id())
 *             .datasources(OrganizationConfigurationDatasourcesArgs.builder()
 *                 .s3Logs(OrganizationConfigurationDatasourcesS3LogsArgs.builder()
 *                     .autoEnable(true)
 *                     .build())
 *                 .kubernetes(OrganizationConfigurationDatasourcesKubernetesArgs.builder()
 *                     .auditLogs(OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs.builder()
 *                         .enable(true)
 *                         .build())
 *                     .build())
 *                 .malwareProtection(OrganizationConfigurationDatasourcesMalwareProtectionArgs.builder()
 *                     .scanEc2InstanceWithFindings(OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder()
 *                         .ebsVolumes(OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs.builder()
 *                             .autoEnable(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty Organization Configurations using the GuardDuty Detector ID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/organizationConfiguration:OrganizationConfiguration example 00b00fd5aecc0ab60a708659477e9617
 * ```
 * @property autoEnable *Deprecated:* Use `auto_enable_organization_members` instead. When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s GuardDuty delegated administrator and GuardDuty is enabled in that AWS Region.
 * @property autoEnableOrganizationMembers Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. Valid values are `ALL`, `NEW`, `NONE`.
 * @property datasources Configuration for the collected datasources.
 * @property detectorId The detector ID of the GuardDuty account.
 */
public data class OrganizationConfigurationArgs(
    @Deprecated(
        message = """
  Use auto_enable_organization_members instead
  """,
    )
    public val autoEnable: Output<Boolean>? = null,
    public val autoEnableOrganizationMembers: Output<String>? = null,
    public val datasources: Output<OrganizationConfigurationDatasourcesArgs>? = null,
    public val detectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.OrganizationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.OrganizationConfigurationArgs =
        com.pulumi.aws.guardduty.OrganizationConfigurationArgs.builder()
            .autoEnable(autoEnable?.applyValue({ args0 -> args0 }))
            .autoEnableOrganizationMembers(autoEnableOrganizationMembers?.applyValue({ args0 -> args0 }))
            .datasources(datasources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .detectorId(detectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationArgsBuilder internal constructor() {
    private var autoEnable: Output<Boolean>? = null

    private var autoEnableOrganizationMembers: Output<String>? = null

    private var datasources: Output<OrganizationConfigurationDatasourcesArgs>? = null

    private var detectorId: Output<String>? = null

    /**
     * @param value *Deprecated:* Use `auto_enable_organization_members` instead. When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s GuardDuty delegated administrator and GuardDuty is enabled in that AWS Region.
     */
    @Deprecated(
        message = """
  Use auto_enable_organization_members instead
  """,
    )
    @JvmName("jjuptlktkjpncwfb")
    public suspend fun autoEnable(`value`: Output<Boolean>) {
        this.autoEnable = value
    }

    /**
     * @param value Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. Valid values are `ALL`, `NEW`, `NONE`.
     */
    @JvmName("ncmgkrqvepqrglnp")
    public suspend fun autoEnableOrganizationMembers(`value`: Output<String>) {
        this.autoEnableOrganizationMembers = value
    }

    /**
     * @param value Configuration for the collected datasources.
     */
    @JvmName("ebxrxcjxyesuguyy")
    public suspend fun datasources(`value`: Output<OrganizationConfigurationDatasourcesArgs>) {
        this.datasources = value
    }

    /**
     * @param value The detector ID of the GuardDuty account.
     */
    @JvmName("owmvslwvmnagnaph")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value *Deprecated:* Use `auto_enable_organization_members` instead. When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s GuardDuty delegated administrator and GuardDuty is enabled in that AWS Region.
     */
    @Deprecated(
        message = """
  Use auto_enable_organization_members instead
  """,
    )
    @JvmName("jdhdhiwtcrlpanjb")
    public suspend fun autoEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    /**
     * @param value Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. Valid values are `ALL`, `NEW`, `NONE`.
     */
    @JvmName("jnnlcvbvjvmvxpwk")
    public suspend fun autoEnableOrganizationMembers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnableOrganizationMembers = mapped
    }

    /**
     * @param value Configuration for the collected datasources.
     */
    @JvmName("akpxhyghvxaqjvjh")
    public suspend fun datasources(`value`: OrganizationConfigurationDatasourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasources = mapped
    }

    /**
     * @param argument Configuration for the collected datasources.
     */
    @JvmName("wkfrvkgtkjlwvywh")
    public suspend
    fun datasources(argument: suspend OrganizationConfigurationDatasourcesArgsBuilder.() -> Unit) {
        val toBeMapped = OrganizationConfigurationDatasourcesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.datasources = mapped
    }

    /**
     * @param value The detector ID of the GuardDuty account.
     */
    @JvmName("mxhpimuggcbtejab")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    internal fun build(): OrganizationConfigurationArgs = OrganizationConfigurationArgs(
        autoEnable = autoEnable,
        autoEnableOrganizationMembers = autoEnableOrganizationMembers,
        datasources = datasources,
        detectorId = detectorId,
    )
}
