@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs
import com.pulumi.aws.guardduty.kotlin.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a single Amazon GuardDuty [organization configuration feature](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-features-activation-model.html#guardduty-features).
 * > **NOTE:** Deleting this resource does not disable the organization configuration feature, the resource in simply removed from state instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationFeature;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Detector("example", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var eksRuntimeMonitoring = new OrganizationConfigurationFeature("eksRuntimeMonitoring", OrganizationConfigurationFeatureArgs.builder()
 *             .detectorId(example.id())
 *             .autoEnable("ALL")
 *             .additionalConfigurations(OrganizationConfigurationFeatureAdditionalConfigurationArgs.builder()
 *                 .name("EKS_ADDON_MANAGEMENT")
 *                 .autoEnable("NEW")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property additionalConfigurations The additional information that will be configured for the organization See below.
 * @property autoEnable The status of the feature that is configured for the member accounts within the organization. Valid values: `NEW`, `ALL`, `NONE`.
 * @property detectorId The ID of the detector that configures the delegated administrator.
 * @property name The name of the feature that will be configured for the organization. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`.
 */
public data class OrganizationConfigurationFeatureArgs(
    public val additionalConfigurations:
    Output<List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>? = null,
    public val autoEnable: Output<String>? = null,
    public val detectorId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs =
        com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs.builder()
            .additionalConfigurations(
                additionalConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .autoEnable(autoEnable?.applyValue({ args0 -> args0 }))
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationFeatureArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationFeatureArgsBuilder internal constructor() {
    private var additionalConfigurations:
        Output<List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>? = null

    private var autoEnable: Output<String>? = null

    private var detectorId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The additional information that will be configured for the organization See below.
     */
    @JvmName("ltxktehvjfxypasj")
    public suspend
    fun additionalConfigurations(`value`: Output<List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = value
    }

    @JvmName("wolrheecbttvxxus")
    public suspend fun additionalConfigurations(
        vararg
        values: Output<OrganizationConfigurationFeatureAdditionalConfigurationArgs>,
    ) {
        this.additionalConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The additional information that will be configured for the organization See below.
     */
    @JvmName("odmidjqchxclxlwq")
    public suspend
    fun additionalConfigurations(values: List<Output<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = Output.all(values)
    }

    /**
     * @param value The status of the feature that is configured for the member accounts within the organization. Valid values: `NEW`, `ALL`, `NONE`.
     */
    @JvmName("qnyfpdmddwnaolgc")
    public suspend fun autoEnable(`value`: Output<String>) {
        this.autoEnable = value
    }

    /**
     * @param value The ID of the detector that configures the delegated administrator.
     */
    @JvmName("xxggmefhidjlfclu")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value The name of the feature that will be configured for the organization. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`.
     */
    @JvmName("jlpnifabjuhqnwkq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The additional information that will be configured for the organization See below.
     */
    @JvmName("vjveektdjqcpatfc")
    public suspend
    fun additionalConfigurations(`value`: List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument The additional information that will be configured for the organization See below.
     */
    @JvmName("heeaqdshpxysdlxa")
    public suspend
    fun additionalConfigurations(argument: List<suspend OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument The additional information that will be configured for the organization See below.
     */
    @JvmName("spvtbmvdkdbahtes")
    public suspend fun additionalConfigurations(
        vararg
        argument: suspend OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument The additional information that will be configured for the organization See below.
     */
    @JvmName("jyqhjngeqftrjqgd")
    public suspend
    fun additionalConfigurations(argument: suspend OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param values The additional information that will be configured for the organization See below.
     */
    @JvmName("stwgiqxownkusbjw")
    public suspend fun additionalConfigurations(
        vararg
        values: OrganizationConfigurationFeatureAdditionalConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param value The status of the feature that is configured for the member accounts within the organization. Valid values: `NEW`, `ALL`, `NONE`.
     */
    @JvmName("sesxwujwpqxnhjfd")
    public suspend fun autoEnable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    /**
     * @param value The ID of the detector that configures the delegated administrator.
     */
    @JvmName("aqqwlskieqvqeydl")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value The name of the feature that will be configured for the organization. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`.
     */
    @JvmName("sgabvmgktcgnubvk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): OrganizationConfigurationFeatureArgs = OrganizationConfigurationFeatureArgs(
        additionalConfigurations = additionalConfigurations,
        autoEnable = autoEnable,
        detectorId = detectorId,
        name = name,
    )
}
