@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PublishingDestination].
 */
@PulumiTagMarker
public class PublishingDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublishingDestinationArgs = PublishingDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublishingDestinationArgsBuilder.() -> Unit) {
        val builder = PublishingDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PublishingDestination {
        val builtJavaResource = com.pulumi.aws.guardduty.PublishingDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PublishingDestination(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a GuardDuty PublishingDestination. Requires an existing GuardDuty Detector.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.guardduty.PublishingDestination;
 * import com.pulumi.aws.guardduty.PublishingDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var gdBucket = new BucketV2("gdBucket", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var bucketPol = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow PutObject")
 *                     .actions("s3:PutObject")
 *                     .resources(gdBucket.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("guardduty.amazonaws.com")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow GetBucketLocation")
 *                     .actions("s3:GetBucketLocation")
 *                     .resources(gdBucket.arn())
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("guardduty.amazonaws.com")
 *                         .build())
 *                     .build())
 *             .build());
 *         final var kmsPol = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow GuardDuty to encrypt findings")
 *                     .actions("kms:GenerateDataKey")
 *                     .resources(String.format("arn:aws:kms:%s:%s:key/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("guardduty.amazonaws.com")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow all users to modify/delete key (test only)")
 *                     .actions("kms:*")
 *                     .resources(String.format("arn:aws:kms:%s:%s:key/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers(String.format("arn:aws:iam::%s:root", currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         .build())
 *                     .build())
 *             .build());
 *         var testGd = new Detector("testGd", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var gdBucketAcl = new BucketAclV2("gdBucketAcl", BucketAclV2Args.builder()
 *             .bucket(gdBucket.id())
 *             .acl("private")
 *             .build());
 *         var gdBucketPolicy = new BucketPolicy("gdBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(gdBucket.id())
 *             .policy(bucketPol.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(bucketPol -> bucketPol.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var gdKey = new Key("gdKey", KeyArgs.builder()
 *             .description("Temporary key for AccTest of TF")
 *             .deletionWindowInDays(7)
 *             .policy(kmsPol.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test = new PublishingDestination("test", PublishingDestinationArgs.builder()
 *             .detectorId(testGd.id())
 *             .destinationArn(gdBucket.arn())
 *             .kmsKeyArn(gdKey.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(gdBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty PublishingDestination using the master GuardDuty detector ID and PublishingDestinationID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/publishingDestination:PublishingDestination test a4b86f26fa42e7e7cf0d1c333ea77777:a4b86f27a0e464e4a7e0516d242f1234
 * ```
 * */*/*/
 */
public class PublishingDestination internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.PublishingDestination,
) : KotlinCustomResource(javaResource, PublishingDestinationMapper) {
    /**
     * The bucket arn and prefix under which the findings get exported. Bucket-ARN is required, the prefix is optional and will be `AWSLogs/[Account-ID]/GuardDuty/[Region]/` if not provided
     */
    public val destinationArn: Output<String>
        get() = javaResource.destinationArn().applyValue({ args0 -> args0 })

    /**
     * Currently there is only "S3" available as destination type which is also the default value
     * > **Note:** In case of missing permissions (S3 Bucket Policy _or_ KMS Key permissions) the resource will fail to create. If the permissions are changed after resource creation, this can be asked from the AWS API via the "DescribePublishingDestination" call (https://docs.aws.amazon.com/cli/latest/reference/guardduty/describe-publishing-destination.html).
     */
    public val destinationType: Output<String>?
        get() = javaResource.destinationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The detector ID of the GuardDuty.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the KMS key used to encrypt GuardDuty findings. GuardDuty enforces this to be encrypted.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })
}

public object PublishingDestinationMapper : ResourceMapper<PublishingDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.PublishingDestination::class == javaResource::class

    override fun map(javaResource: Resource): PublishingDestination =
        PublishingDestination(javaResource as com.pulumi.aws.guardduty.PublishingDestination)
}

/**
 * @see [PublishingDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublishingDestination].
 */
public suspend fun publishingDestination(
    name: String,
    block: suspend PublishingDestinationResourceBuilder.() -> Unit,
): PublishingDestination {
    val builder = PublishingDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublishingDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publishingDestination(name: String): PublishingDestination {
    val builder = PublishingDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
