@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.PublishingDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a GuardDuty PublishingDestination. Requires an existing GuardDuty Detector.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.guardduty.PublishingDestination;
 * import com.pulumi.aws.guardduty.PublishingDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var gdBucket = new BucketV2("gdBucket", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var bucketPol = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow PutObject")
 *                     .actions("s3:PutObject")
 *                     .resources(gdBucket.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("guardduty.amazonaws.com")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow GetBucketLocation")
 *                     .actions("s3:GetBucketLocation")
 *                     .resources(gdBucket.arn())
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("guardduty.amazonaws.com")
 *                         .build())
 *                     .build())
 *             .build());
 *         final var kmsPol = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow GuardDuty to encrypt findings")
 *                     .actions("kms:GenerateDataKey")
 *                     .resources(String.format("arn:aws:kms:%s:%s:key/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("guardduty.amazonaws.com")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("Allow all users to modify/delete key (test only)")
 *                     .actions("kms:*")
 *                     .resources(String.format("arn:aws:kms:%s:%s:key/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers(String.format("arn:aws:iam::%s:root", currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         .build())
 *                     .build())
 *             .build());
 *         var testGd = new Detector("testGd", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var gdBucketAcl = new BucketAclV2("gdBucketAcl", BucketAclV2Args.builder()
 *             .bucket(gdBucket.id())
 *             .acl("private")
 *             .build());
 *         var gdBucketPolicy = new BucketPolicy("gdBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(gdBucket.id())
 *             .policy(bucketPol.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(bucketPol -> bucketPol.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var gdKey = new Key("gdKey", KeyArgs.builder()
 *             .description("Temporary key for AccTest of TF")
 *             .deletionWindowInDays(7)
 *             .policy(kmsPol.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test = new PublishingDestination("test", PublishingDestinationArgs.builder()
 *             .detectorId(testGd.id())
 *             .destinationArn(gdBucket.arn())
 *             .kmsKeyArn(gdKey.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(gdBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GuardDuty PublishingDestination using the master GuardDuty detector ID and PublishingDestinationID. For example:
 * ```sh
 *  $ pulumi import aws:guardduty/publishingDestination:PublishingDestination test a4b86f26fa42e7e7cf0d1c333ea77777:a4b86f27a0e464e4a7e0516d242f1234
 * ```
 * @property destinationArn The bucket arn and prefix under which the findings get exported. Bucket-ARN is required, the prefix is optional and will be `AWSLogs/[Account-ID]/GuardDuty/[Region]/` if not provided
 * @property destinationType Currently there is only "S3" available as destination type which is also the default value
 * > **Note:** In case of missing permissions (S3 Bucket Policy _or_ KMS Key permissions) the resource will fail to create. If the permissions are changed after resource creation, this can be asked from the AWS API via the "DescribePublishingDestination" call (https://docs.aws.amazon.com/cli/latest/reference/guardduty/describe-publishing-destination.html).
 * @property detectorId The detector ID of the GuardDuty.
 * @property kmsKeyArn The ARN of the KMS key used to encrypt GuardDuty findings. GuardDuty enforces this to be encrypted.
 * */*/*/
 */
public data class PublishingDestinationArgs(
    public val destinationArn: Output<String>? = null,
    public val destinationType: Output<String>? = null,
    public val detectorId: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.PublishingDestinationArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.PublishingDestinationArgs =
        com.pulumi.aws.guardduty.PublishingDestinationArgs.builder()
            .destinationArn(destinationArn?.applyValue({ args0 -> args0 }))
            .destinationType(destinationType?.applyValue({ args0 -> args0 }))
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublishingDestinationArgs].
 */
@PulumiTagMarker
public class PublishingDestinationArgsBuilder internal constructor() {
    private var destinationArn: Output<String>? = null

    private var destinationType: Output<String>? = null

    private var detectorId: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value The bucket arn and prefix under which the findings get exported. Bucket-ARN is required, the prefix is optional and will be `AWSLogs/[Account-ID]/GuardDuty/[Region]/` if not provided
     */
    @JvmName("lraivfnekufuujqq")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value Currently there is only "S3" available as destination type which is also the default value
     * > **Note:** In case of missing permissions (S3 Bucket Policy _or_ KMS Key permissions) the resource will fail to create. If the permissions are changed after resource creation, this can be asked from the AWS API via the "DescribePublishingDestination" call (https://docs.aws.amazon.com/cli/latest/reference/guardduty/describe-publishing-destination.html).
     */
    @JvmName("ogvhtfaedagdxqul")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value The detector ID of the GuardDuty.
     */
    @JvmName("onphwjssaobjpnxf")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value The ARN of the KMS key used to encrypt GuardDuty findings. GuardDuty enforces this to be encrypted.
     */
    @JvmName("jbjkiwegxhwiqith")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The bucket arn and prefix under which the findings get exported. Bucket-ARN is required, the prefix is optional and will be `AWSLogs/[Account-ID]/GuardDuty/[Region]/` if not provided
     */
    @JvmName("nlhguvdtmlxhwwmi")
    public suspend fun destinationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value Currently there is only "S3" available as destination type which is also the default value
     * > **Note:** In case of missing permissions (S3 Bucket Policy _or_ KMS Key permissions) the resource will fail to create. If the permissions are changed after resource creation, this can be asked from the AWS API via the "DescribePublishingDestination" call (https://docs.aws.amazon.com/cli/latest/reference/guardduty/describe-publishing-destination.html).
     */
    @JvmName("bbmippqoevtpeokq")
    public suspend fun destinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value The detector ID of the GuardDuty.
     */
    @JvmName("fsdeqyfcesvilhqk")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value The ARN of the KMS key used to encrypt GuardDuty findings. GuardDuty enforces this to be encrypted.
     */
    @JvmName("yipnssxufthvcffr")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): PublishingDestinationArgs = PublishingDestinationArgs(
        destinationArn = destinationArn,
        destinationType = destinationType,
        detectorId = detectorId,
        kmsKeyArn = kmsKeyArn,
    )
}
