@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property scanEc2InstanceWithFindings Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) is enabled as data source for EC2 instances with findings for the detector.
 * See Scan EC2 instance with findings below for more details.
 */
public data class DetectorDatasourcesMalwareProtectionArgs(
    public val scanEc2InstanceWithFindings:
    Output<DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs>,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionArgs =
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionArgs.builder()
            .scanEc2InstanceWithFindings(
                scanEc2InstanceWithFindings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DetectorDatasourcesMalwareProtectionArgs].
 */
@PulumiTagMarker
public class DetectorDatasourcesMalwareProtectionArgsBuilder internal constructor() {
    private var scanEc2InstanceWithFindings:
        Output<DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs>? = null

    /**
     * @param value Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) is enabled as data source for EC2 instances with findings for the detector.
     * See Scan EC2 instance with findings below for more details.
     */
    @JvmName("oarxqigqanpfubch")
    public suspend
    fun scanEc2InstanceWithFindings(`value`: Output<DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs>) {
        this.scanEc2InstanceWithFindings = value
    }

    /**
     * @param value Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) is enabled as data source for EC2 instances with findings for the detector.
     * See Scan EC2 instance with findings below for more details.
     */
    @JvmName("dawmnmekmhbdutap")
    public suspend
    fun scanEc2InstanceWithFindings(`value`: DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanEc2InstanceWithFindings = mapped
    }

    /**
     * @param argument Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) is enabled as data source for EC2 instances with findings for the detector.
     * See Scan EC2 instance with findings below for more details.
     */
    @JvmName("ybeblmtdoelgarly")
    public suspend
    fun scanEc2InstanceWithFindings(argument: suspend DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scanEc2InstanceWithFindings = mapped
    }

    internal fun build(): DetectorDatasourcesMalwareProtectionArgs =
        DetectorDatasourcesMalwareProtectionArgs(
            scanEc2InstanceWithFindings = scanEc2InstanceWithFindings ?: throw
                PulumiNullFieldException("scanEc2InstanceWithFindings"),
        )
}
