@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ebsVolumes Configure whether scanning EBS volumes is enabled as data source for the detector for instances with findings.
 * See EBS volumes below for more details.
 */
public data class DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs(
    public val ebsVolumes:
    Output<DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs> {
    override fun toJava():
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs =
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder()
            .ebsVolumes(ebsVolumes.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs].
 */
@PulumiTagMarker
public class DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgsBuilder internal
constructor() {
    private var ebsVolumes:
        Output<DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs>? = null

    /**
     * @param value Configure whether scanning EBS volumes is enabled as data source for the detector for instances with findings.
     * See EBS volumes below for more details.
     */
    @JvmName("wrnxcosxlpbdtmxj")
    public suspend
    fun ebsVolumes(`value`: Output<DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs>) {
        this.ebsVolumes = value
    }

    /**
     * @param value Configure whether scanning EBS volumes is enabled as data source for the detector for instances with findings.
     * See EBS volumes below for more details.
     */
    @JvmName("dxlmpjbaglqvnckf")
    public suspend
    fun ebsVolumes(`value`: DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param argument Configure whether scanning EBS volumes is enabled as data source for the detector for instances with findings.
     * See EBS volumes below for more details.
     */
    @JvmName("sgcbeomppiubohti")
    public suspend
    fun ebsVolumes(argument: suspend DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgsBuilder.() -> Unit) {
        val toBeMapped =
            DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    internal fun build(): DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs =
        DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs(
            ebsVolumes = ebsVolumes ?: throw PulumiNullFieldException("ebsVolumes"),
        )
}
