@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable If true, enables [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) as data source for the detector.
 * Defaults to `true`.
 */
public data class DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs(
    public val enable: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs> {
    override fun toJava():
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs =
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs.builder()
            .enable(enable.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs].
 */
@PulumiTagMarker
public class DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgsBuilder
internal constructor() {
    private var enable: Output<Boolean>? = null

    /**
     * @param value If true, enables [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) as data source for the detector.
     * Defaults to `true`.
     */
    @JvmName("gildcsnphdmfuamj")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value If true, enables [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) as data source for the detector.
     * Defaults to `true`.
     */
    @JvmName("biqhagqnnabyjbct")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    internal fun build():
        DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs =
        DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs(
            enable = enable ?: throw PulumiNullFieldException("enable"),
        )
}
