@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesS3LogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable Enable monitoring and feedback reporting. Setting to `false` is equivalent to "suspending" GuardDuty. Defaults to `true`.
 */
public data class DetectorDatasourcesS3LogsArgs(
    public val enable: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.DetectorDatasourcesS3LogsArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.DetectorDatasourcesS3LogsArgs =
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesS3LogsArgs.builder()
            .enable(enable.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DetectorDatasourcesS3LogsArgs].
 */
@PulumiTagMarker
public class DetectorDatasourcesS3LogsArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    /**
     * @param value Enable monitoring and feedback reporting. Setting to `false` is equivalent to "suspending" GuardDuty. Defaults to `true`.
     */
    @JvmName("gbuptmhwkacbogkp")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Enable monitoring and feedback reporting. Setting to `false` is equivalent to "suspending" GuardDuty. Defaults to `true`.
     */
    @JvmName("dvcteyggpfxqrcom")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    internal fun build(): DetectorDatasourcesS3LogsArgs = DetectorDatasourcesS3LogsArgs(
        enable = enable ?: throw PulumiNullFieldException("enable"),
    )
}
