@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.DetectorFeatureAdditionalConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the additional configuration. Valid values: `EKS_ADDON_MANAGEMENT`.
 * @property status The status of the additional configuration. Valid values: `ENABLED`, `DISABLED`.
 */
public data class DetectorFeatureAdditionalConfigurationArgs(
    public val name: Output<String>,
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.DetectorFeatureAdditionalConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.DetectorFeatureAdditionalConfigurationArgs =
        com.pulumi.aws.guardduty.inputs.DetectorFeatureAdditionalConfigurationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DetectorFeatureAdditionalConfigurationArgs].
 */
@PulumiTagMarker
public class DetectorFeatureAdditionalConfigurationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The name of the additional configuration. Valid values: `EKS_ADDON_MANAGEMENT`.
     */
    @JvmName("ttxwpkrrwjhunrpj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The status of the additional configuration. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("lymlgpbuandhsqhp")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the additional configuration. Valid values: `EKS_ADDON_MANAGEMENT`.
     */
    @JvmName("vkdknjpndxobucms")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The status of the additional configuration. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("tvqdnapiceqotrcg")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DetectorFeatureAdditionalConfigurationArgs =
        DetectorFeatureAdditionalConfigurationArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
