@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property equals List of string values to be evaluated.
 * @property field The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
 * @property greaterThan A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property greaterThanOrEqual A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property lessThan A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property lessThanOrEqual A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property notEquals List of string values to be evaluated.
 */
public data class FilterFindingCriteriaCriterionArgs(
    public val equals: Output<List<String>>? = null,
    public val `field`: Output<String>,
    public val greaterThan: Output<String>? = null,
    public val greaterThanOrEqual: Output<String>? = null,
    public val lessThan: Output<String>? = null,
    public val lessThanOrEqual: Output<String>? = null,
    public val notEquals: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs =
        com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs.builder()
            .equals_(equals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`field`(`field`.applyValue({ args0 -> args0 }))
            .greaterThan(greaterThan?.applyValue({ args0 -> args0 }))
            .greaterThanOrEqual(greaterThanOrEqual?.applyValue({ args0 -> args0 }))
            .lessThan(lessThan?.applyValue({ args0 -> args0 }))
            .lessThanOrEqual(lessThanOrEqual?.applyValue({ args0 -> args0 }))
            .notEquals(notEquals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FilterFindingCriteriaCriterionArgs].
 */
@PulumiTagMarker
public class FilterFindingCriteriaCriterionArgsBuilder internal constructor() {
    private var equals: Output<List<String>>? = null

    private var `field`: Output<String>? = null

    private var greaterThan: Output<String>? = null

    private var greaterThanOrEqual: Output<String>? = null

    private var lessThan: Output<String>? = null

    private var lessThanOrEqual: Output<String>? = null

    private var notEquals: Output<List<String>>? = null

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("uvqnslxnndwrgsek")
    public suspend fun equals(`value`: Output<List<String>>) {
        this.equals = value
    }

    @JvmName("kqbhdhtgxmsmufeq")
    public suspend fun equals(vararg values: Output<String>) {
        this.equals = Output.all(values.asList())
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("jegshoulsnglldci")
    public suspend fun equals(values: List<Output<String>>) {
        this.equals = Output.all(values)
    }

    /**
     * @param value The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
     */
    @JvmName("fgvrpmgsxscamldq")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("voctrdeugrborxjl")
    public suspend fun greaterThan(`value`: Output<String>) {
        this.greaterThan = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("kcwvnjpgutbdrppf")
    public suspend fun greaterThanOrEqual(`value`: Output<String>) {
        this.greaterThanOrEqual = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("djbusvfsewunoira")
    public suspend fun lessThan(`value`: Output<String>) {
        this.lessThan = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("iouthkejsaypklvr")
    public suspend fun lessThanOrEqual(`value`: Output<String>) {
        this.lessThanOrEqual = value
    }

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("ndgeckeaiokkidkv")
    public suspend fun notEquals(`value`: Output<List<String>>) {
        this.notEquals = value
    }

    @JvmName("qvkbuxjbjxmqkkmk")
    public suspend fun notEquals(vararg values: Output<String>) {
        this.notEquals = Output.all(values.asList())
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("plutuhaawdfkfscq")
    public suspend fun notEquals(values: List<Output<String>>) {
        this.notEquals = Output.all(values)
    }

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("gbbtdnudeoquiwfu")
    public suspend fun equals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("ubdualrhkwucygvk")
    public suspend fun equals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param value The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
     */
    @JvmName("pejjuvvtxorkcwee")
    public suspend fun `field`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("hnvjphrjmyfpywif")
    public suspend fun greaterThan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.greaterThan = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("mxnoxwxjntqdyenk")
    public suspend fun greaterThanOrEqual(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.greaterThanOrEqual = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("nohhymdmrghhjprv")
    public suspend fun lessThan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lessThan = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("wdedmhjsbjxhllrv")
    public suspend fun lessThanOrEqual(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lessThanOrEqual = mapped
    }

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("hhgytfrslbqedwtc")
    public suspend fun notEquals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notEquals = mapped
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("mwxqvmvxkoifxyls")
    public suspend fun notEquals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notEquals = mapped
    }

    internal fun build(): FilterFindingCriteriaCriterionArgs = FilterFindingCriteriaCriterionArgs(
        equals = equals,
        `field` = `field` ?: throw PulumiNullFieldException("field"),
        greaterThan = greaterThan,
        greaterThanOrEqual = greaterThanOrEqual,
        lessThan = lessThan,
        lessThanOrEqual = lessThanOrEqual,
        notEquals = notEquals,
    )
}
