@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.GetDetectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDetector.
 * @property id ID of the detector.
 */
public data class GetDetectorPlainArgs(
    public val id: String? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.GetDetectorPlainArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.GetDetectorPlainArgs =
        com.pulumi.aws.guardduty.inputs.GetDetectorPlainArgs.builder()
            .id(id?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDetectorPlainArgs].
 */
@PulumiTagMarker
public class GetDetectorPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value ID of the detector.
     */
    @JvmName("mekkqfwkxcedxlcu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetDetectorPlainArgs = GetDetectorPlainArgs(
        id = id,
    )
}
