@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.GetFindingIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFindingIds.
 * @property detectorId ID of the GuardDuty detector.
 */
public data class GetFindingIdsPlainArgs(
    public val detectorId: String,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.GetFindingIdsPlainArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.GetFindingIdsPlainArgs =
        com.pulumi.aws.guardduty.inputs.GetFindingIdsPlainArgs.builder()
            .detectorId(detectorId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFindingIdsPlainArgs].
 */
@PulumiTagMarker
public class GetFindingIdsPlainArgsBuilder internal constructor() {
    private var detectorId: String? = null

    /**
     * @param value ID of the GuardDuty detector.
     */
    @JvmName("nddqfpslmhmtxypm")
    public suspend fun detectorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.detectorId = mapped
    }

    internal fun build(): GetFindingIdsPlainArgs = GetFindingIdsPlainArgs(
        detectorId = detectorId ?: throw PulumiNullFieldException("detectorId"),
    )
}
