@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property auditLogs Enable Kubernetes Audit Logs Monitoring automatically for new member accounts. [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * See Kubernetes Audit Logs below for more details.
 */
public data class OrganizationConfigurationDatasourcesKubernetesArgs(
    public val auditLogs: Output<OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesArgs> {
    override fun toJava():
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesArgs =
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesArgs.builder()
            .auditLogs(auditLogs.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OrganizationConfigurationDatasourcesKubernetesArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationDatasourcesKubernetesArgsBuilder internal constructor() {
    private var auditLogs: Output<OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs>? = null

    /**
     * @param value Enable Kubernetes Audit Logs Monitoring automatically for new member accounts. [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes Audit Logs below for more details.
     */
    @JvmName("djyfgyghoksylphh")
    public suspend
    fun auditLogs(`value`: Output<OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs>) {
        this.auditLogs = value
    }

    /**
     * @param value Enable Kubernetes Audit Logs Monitoring automatically for new member accounts. [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes Audit Logs below for more details.
     */
    @JvmName("tnjaawpktkboakcm")
    public suspend
    fun auditLogs(`value`: OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auditLogs = mapped
    }

    /**
     * @param argument Enable Kubernetes Audit Logs Monitoring automatically for new member accounts. [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes Audit Logs below for more details.
     */
    @JvmName("ixqyynjkajjnmbnq")
    public suspend
    fun auditLogs(argument: suspend OrganizationConfigurationDatasourcesKubernetesAuditLogsArgsBuilder.() -> Unit) {
        val toBeMapped =
            OrganizationConfigurationDatasourcesKubernetesAuditLogsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.auditLogs = mapped
    }

    internal fun build(): OrganizationConfigurationDatasourcesKubernetesArgs =
        OrganizationConfigurationDatasourcesKubernetesArgs(
            auditLogs = auditLogs ?: throw PulumiNullFieldException("auditLogs"),
        )
}
